//
//  ViewControllerProtocol.h
//  NebulaApp
//
//  Created by lyusheng on 2018/8/13.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NXControllerDelegate.h"
#import "NXDWebViewInjection.h"
#import "NXANavigationBarManager.h"
#import <AriverApi/RVPTabBarManager.h>
#if INDEPENDENT
#import <AriverApp/RVAToolbarMenu.h>
#endif
//#import <AriverApp/RVAProgressView.h>
#import "NXDPageOption.h"
#import "NXDNavigationBar.h"

@class NXKPage;
/**
 ViewController的协议抽象
 由外部提供实现。
 
 实现者必须同时实现NXControllerDelegate: 为Scene提供相关的Delegate方法
 */
@protocol ViewControllerProtocol <NXControllerDelegate,NXViewControllerLifeEvent, RVKExpandoProtocol>


@optional
// 考虑一下是否需要放在这里，暂时放这里，是因为VC有访问
@property(nonatomic, readonly, strong) id<NXDPageOption>              options;

/**
 如果是webview，js注入相关逻辑的delegate
 */
@property (nonatomic, strong) id<NXDWebViewInjection> webViewInjectDelegate;
@property (nonatomic) id<NXDNavigationTitleView> navigationTitleView;

@property (nonatomic) RVPTabBarManager *tabBarManager; // 如果有小程序配置了tabBar，才会使用
@property (nonatomic) NXANavigationBarManager *navigationBarManager;

#if INDEPENDENT
@property (nonatomic) RVAToolbarMenu *toolbar;
@property (nonatomic) NSString *contentProvider;
#endif

@property (nonatomic) id<RVAProgressViewProtocol> nxProgressView;
@property (nonatomic) BOOL isFallbackMode;
@property (nonatomic) BOOL originshowProgress;

@required
/**
 与controller对应的page
 
 TODO 改名
 - (NXKPage *)page;

 @return controller对应的page
 */
- (NXKPage *)scene;
// TODO 确定是否在 scene上可以拿到rvkView， 确认是否多余
- (RVKView *)rvkView;

/**
 id<NXEngineContentView>，目前类型为UIView

 @return id<NXEngineContentView>实例，渲染的view
 */
- (UIView *)contentView;

-(void)sendCreateRightItemsEvent;

- (id<ViewControllerProtocol>)viewControllerIMP;


/**
 app类型判断小程序

 @return 是否为小程序
 */
- (BOOL)isApplet;
@end

@protocol WebViewControllerProtocol <ViewControllerProtocol>

// ------ COPY from RVKViewControllerProtocol ------
@optional
#pragma mark - Deprecated, WebView相关的delegate移动到NXDWebViewInjection
//- (NSArray *)dynamicJsUrls; // 动态注入js数组
//
//- (NSString *)startupParamsJs; // 启动参数js
//
//- (NSString *)codeSnippets4InsertAlipayJsBridgeFile; // 动态插入js片段；该方法是在插入js之前修改js文件
//
//- (void)startFirstLoadRequest:(NSURL *)url; // 如果实现了该方法，需要自己loadRequest；该方法是第一次进入页面发起的请求
//
//- (NSArray *)independenceUserScripts; // RVKWebViewUserScript
//
//- (NSArray *)relayOnAlipayJsBridgeUserScripts; // RVKWebViewUserScript
//
//- (void)injectIndependenceJs; // 注入单独的JS文件
//
//- (void)injectJsRelyOnAlipayJsBridge; // 依赖于AlipayJSBridge
//// RVKView初始化过程中，注入用户的scripts
//- (NSString *)allJsInjectToJSC; //通过JSC注入的JS
@required

#pragma mark - Deprecated, 可以使用app属性访问到关联的节点
//- (RVKScene *)rvkScene;
//
//- (RVKSession *)rvkSession;
//
//- (RVKView *)rvkView;
//
//- (RVKContentView *)rvkContentView;
#pragma mark - Deprecated 这两个方法的作用非delegate给VC实现者，而是为VC实现者提供了API，已转到NXKPage中，后续直接调用Scene中接口
//- (void)callHandler:(NSString *)handlerName
//               data:(id)data
//   responseCallback:(void(^)(id responseData))callback;
//
//- (void)callHandler:(NSString *)handlerName
//               data:(id)data
//callbackImmediatelyIfJSBridgeNotReady:(BOOL)callbackImmediatelyIfJSBridgeNotReady
//   responseCallback:(void (^)(id responseData))callback;
@end
