//
//  ViewControllerIMP.h
//  NebulaApp
//
//  Created by lyusheng on 2018/8/22.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ViewControllerProtocol.h"
#import <AriverApp/RVANavigationTitleViewProtocol.h>
#import <AriverApi/RVPTabBarManager.h>

@interface ViewCOntrollerStatusTODEL : NSObject
@property(nonatomic, assign) int isInited;
@property(nonatomic, assign) int didShowCloseBtn;
@property(nonatomic, assign) int isViewReady;
@property(nonatomic, assign) BOOL isViewWillDisappear;
@property(nonatomic, assign) BOOL didDidEnterBackground;
@end
#define kNBXVersion                             @"1.0.0"
/**
 ViewControllerProtocol的实现
 
 Controller应该共有的行为及功能.其他逻辑抛出给 外部传入的UIViewController
 */
@interface ViewControllerIMP : NSObject<ViewControllerProtocol,RVKExpandoProtocol>

@property (nonatomic) id<NXDNavigationTitleView> navigationTitleView;
@property (nonatomic, strong) id<NXDWebViewInjection> webViewInjectDelegate;
@property (nonatomic) RVPTabBarManager *tabBarManager;
@property (nonatomic) NXANavigationBarManager *navigationBarManager;
#if INDEPENDENT
@property (nonatomic) RVAToolbarMenu *toolbar;
@property (nonatomic) NSString *contentProvider;
#endif

@property (nonatomic) id<RVAProgressViewProtocol> nxProgressView;
@property (nonatomic) BOOL isFallbackMode;
@property (nonatomic) BOOL originshowProgress;

// 通用属性
@property(nonatomic, readonly, strong) id<NXDPageOption>              options;
@property(nonatomic, readonly, copy) NSString                             *channelId;
@property(nonatomic, readonly, copy) NSString                             *customUserAgent;
@property(nonatomic, readonly, strong) ViewCOntrollerStatusTODEL             *myFlags;

- (instancetype)initWithTarget:(UIViewController *)target;

- (void)back;

- (void)clearAndBack;

- (void)close;

- (void)popToViewController:(UIViewController *)vc animated:(BOOL)animated;

- (void)popToWindowOfIndex:(NSInteger)indexPopTo;

- (void)popViewControllerAnimated:(BOOL)animated;

- (void)pushViewController:(UIViewController *)viewController animated:(BOOL)animated;

- (void)addDelayCallback:(void(^)(void))callback;

- (void)showCloseItemIfNeeded;

- (void)doShowCloseItemIfNeeded:(BOOL)needed;

- (NSString *)startupParamsJs;
/**
 *  重新设置整个options,业务谨慎使用
 *
 *  @date 2017-06-07
 *
 */
- (void)resetOptions:(id<NXDPageOption>)options;

/**
 设置MainTitle的事件

 @param mainTitle
 @param subtitle
 */
- (void)sendSetMainTitleEvent:(NSString *)mainTitle subtitle:(NSString *)subtitle;

/**
 重置返回状态

 */
- (void)resetBackStatus;

#pragma mark - 被plugin使用的方法, RVAViewControllerProxy的对应的方法在private.h中
- (void)sendCreateRightItemsEvent;

@end
