//
//  NXRenderContentViewProtocol.h
//  NebulaApp
//
//  Created by lyusheng on 2019/11/21.
//  Copyright © 2019 Alipay. All rights reserved.
//

#ifndef NXRenderContentViewProtocol_h
#define NXRenderContentViewProtocol_h

//--------------------------------------------------------
typedef NS_ENUM(NSInteger, NXRenderType  ) {
    NXRenderTypeDefault = 0,
    NXRenderTypeCubeApp,  // 完整Cube
    NXRenderTypePageCube,    // 单页Cube
    NXRenderTypePaladin      // paladin
};

@protocol NXEngineViewDelegate
//- (RVKKernel *)nodeObject;//Page对象的父亲节点
@end

@protocol NXEngineRender1 <NSObject>

@end

/**
 * 类似NXKView/RVKView
 * Engine层的替代务
 */
@protocol NXEngineView <NSObject>

- (NXRenderType)pageRenderType;// 当前scene最终renderType

- (RVKContentView *)contentView;

- (RVKPage *)page;

- (RVKViewParam *)viewParam;

- (RVKKernel<NXEngineViewDelegate> *)delegate;

- (void)loadRequest; DEPRECATED_MSG_ATTRIBUTE("请实现 [-(void)engineStartLoad]");

- (void)engineStartLoad;

- (void)cancelInjectJS;

- (UIImage *)snapshotForView:(UIView *)view;

@optional
- (NSString *)viewId;

@end

//--------------------------------------------------------
@protocol NXEngineContentView <RVKContentViewProtocol>

- (UIImage *)snapshotView:(NSDictionary *)params;
- (NSString *)instanceID;
@property(nonatomic, weak) id<NXEngineView> weakParentView;

@end

#endif /* NXRenderContentViewProtocol_h */
