//
//  NXEngineProtocol.h
//  NebulaApp
//
//  Created by lyusheng on 2019/11/21.
//  Copyright © 2019 Alipay. All rights reserved.
//

#ifndef NXEngineProtocol_h
#define NXEngineProtocol_h

#import <NebulaApp/NXEngineViewProtocol.h>

extern NSString * const kNXESessionExpando_EngineInstance;

//--------------------------------------------------------
@protocol NXRenderInstance

/*
 容器默认降级策略：直接降级到WebView版本小程序。以下特殊场景：
 - cube 答答星球，需要强制降到老容器
 - 77700303（应用中心cube小程序），需要降级native
 
 考虑需要弹alert，并且显示空白
 */
@property (nonatomic) BOOL forceDowngrade;

@property (nonatomic) NXRenderType renderType;

@end
//--------------------------------------------------------
@protocol NXRenderEngine
@required
+ (id<NXRenderInstance>)startEngine:(RVKSession *)session;

+ (id<NXEngineView> )createView:(RVKKernel<NXEngineViewDelegate> *)viewDelegate;

+ (NSString *)userAgent;// 在 baseUserAgent 基础上，带上容器和应用信息的 UA 串

+ (NSString *)baseUserAgent;// 只有系统默认 UA 信息 + 'ChannelId(0) NebulaSDK/1.8.100112 Nebula'

+ (BOOL)hasDowngradeErrorOccured:(NSDictionary *)info;// public
@end

#endif /* NXEngineProtocol_h */
