//
//  NXDNavigationBar.h
//  NebulaApp
//
//  Created by lyusheng on 2018/8/13.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@protocol NXDNavigationBar <NSObject>
@end

@protocol NXNavigationTitleViewDelegate <NSObject>

@optional
// 点击了主标题
- (void)navigationTitleView:(id<RVANavigationTitleViewProtocol>)navigationTitleView didClickedMainTitleView:(UIView *)mainTitleView;
// 点击了副标题
- (void)navigationTitleView:(id<RVANavigationTitleViewProtocol>)navigationTitleView didClickedSubTitleView:(UIView *)subtitleView;
// 点击了右边图标
- (void)navigationTitleView:(id<RVANavigationTitleViewProtocol>)navigationTitleView didClickedRightIconView:(UIView *)rightIconView;

@end

@protocol NXDNavigationTitleView<NSObject>
@required
// mainTitle
- (void)setMainTitle:(NSString *)mainTitle subtitle:(NSString *)subtitle;

// titleLoading
- (void)showTitleLoading;

- (void)hideTitleLoading;

@optional
// mainTitleLabel
- (UILabel *)mainTitleLabel;

// subtitleLabel
- (UILabel *)subtitleLabel;

// padding
- (void)setPaddingLeft:(CGFloat)paddingLeft;

- (void)setPaddingRight:(CGFloat)paddingRight;

// right icon
- (void)setRightIconImage:(UIImage *)image;

- (void)setRightIconWidth:(CGFloat)width;

- (void)setCanShowRightIconWhenSubTitleIsWhitespace:(BOOL)canShow; // defult is NO

// delegate
- (void)setDelegate:(id<RVANavigationTitleViewDelegate>)delegate;

- (id<NXNavigationTitleViewDelegate>)delegate;

- (void)doAnimationRightIcon:(BOOL)isDown;

// rightIconImageView
- (UIImageView *)rightIconImageView;
@end
