//
//  ViewControllerProtocol.h
//  NebulaApp
//
//  Created by lyusheng on 2018/8/13.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 ViewController的生命周期的事件
 vcIMP ——> Scene
 */
@protocol NXViewControllerLifeEvent <NSObject>
@optional
- (void)controller:(UIViewController *)vc loadView:(BOOL)_;
- (void)controller:(UIViewController *)vc viewDidLoad:(BOOL)_;
- (void)controller:(UIViewController *)vc viewDidUnLoad:(BOOL)_;
- (void)controller:(UIViewController *)vc viewWillAppear:(BOOL)_;
- (void)controller:(UIViewController *)vc viewDidAppear:(BOOL)_;
- (void)controller:(UIViewController *)vc viewDidLayoutSubviews:(BOOL)_;
- (void)controller:(UIViewController *)vc viewWillDisappear:(BOOL)_;
- (void)controller:(UIViewController *)vc viewDidDisappear:(BOOL)_;
- (void)controller:(UIViewController *)vc viewWillDestroy:(BOOL)_;

// 
- (void)lifecycle_didReceiveMemoryWarning;
@end

@class NXEContentView;
@class NXKPage;
@class NXKView;

/**
 NXAApp的Controller委托
 app/page/view ——> vcIMP
 */
@protocol NXControllerDelegate <NSObject>

/**
 controller可能会对scene进行持有处理
 @param scene scene实例， 若实现者需要对scene进行持有，应当使用Weak
 @param sceneParam scene的创建参数
 */
//- (void)associateWeakScene:(NXKPage *)scene sceneParam:(RVKSceneParam *)sceneParam DEPRECATED_ATTRIBUTE;
- (void)onPageDidCreate:(NXKPage *)scene param:(RVKSceneParam *)sceneParam;

- (void)setViewControllerLifeEventListener:(id<NXViewControllerLifeEvent>)delegate;


/**
 需要监听View的创建，ViewController
 
 @param view    view对象（容器中View节点，其属性contentView是UIView）
 @param delegate vc 生命周期事件的监听者
 */
- (void)onViewDidCreate:(NXKView *)view vcLifeEventListener:(id<NXViewControllerLifeEvent>)delegate;
@end

/**
 ViewController能力（Integration层VC差异化提供）
 
 vcIMP --> XXXViewController
 */
@protocol NXControllerIntegrationDelegate <NSObject>

@optional
- (NSString *)viewControllerIMPUserAgentSuffix;
@required
- (void)viewControllerIMPDidInit;
- (void)viewControllerIMPViewDidLoad;
@end
