//
//  NXAUtils.h
//  NebulaApp
//
//  Created by 柱石 on 2018/8/13.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 * 从NSDictonary中取值，如果key对应的value 不是 NSString, 则返回null
 */
NSString *NXASafeGetDictString(NSDictionary *dict, NSString *key);

/**
 * 从NSDictonary中取值，如果key对应的value 不是 NSNumber, 则返回null
 */
NSNumber *NXASafeGetDictNumber(NSDictionary *dict,NSString *key);

/**
 * 从NSDictonary中取值，返回前删掉该Key
 */
id NXARemoveFromDict(NSMutableDictionary *dict, NSString *key);

/*
 * 检查String是否合法
 * i.g
 *  "" : false
 *  " ": true
 *  @() : false
 *  null : false
 */
BOOL NXAIsValidString(NSString *str);
