//
//  NXAConfig.h
//  新容器统一开关
//
//  Created by 张光宇 on 2018/11/22.
//  Copyright © 2018 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface NXAConfigManager : NSObject
/**
 * AppId开启FullLink，默认开启
 * 对新旧容器都有效
 */
+ (BOOL)isFullLinkOn:(NSString *)appId;

+ (BOOL)enableCubeHotUpdate;

+ (BOOL)isAppxRouteEnable:(NSString *)appId; // appx切流开关
// 新容器开关
+ (BOOL)isNebulaxOn:(NSString *)appId url:(nullable NSString *)url;

// 这个开关只给包管理判断，其他场景勿用！
+ (BOOL)isNebulaxOn:(NSString *)appId checkPackageProtocol:(BOOL)checkPackageProtocol;

// 查找容器启动的时候，实际使用的离线包
+ (NAMApp *)findInstalledApp:(NSString *)appId;

+ (BOOL)shouldCubeFallbackToH5:(NSString *)appI;
@end

NS_ASSUME_NONNULL_END
