//
//  NXAAppSession.h
//  NebulaApp
//
//  Created by lyusheng on 2018/8/13.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <NebulaResource/NebulaResource.h>
#import "NXAAppContext.h"
#import "ViewControllerProtocol.h"
#import <AriverApp/AriverApp.h>
#import <AriverApp/RVASession.h>

/**
 Description:
 
    Lib        Global         holder              node         node        node         node
   -----        -----          -----               -----       -----       -----        -----
   Ariver
             RVKService                         RVKSession   RVKScene     RVKView      RVKPage
                        RVASession(&Context)
   -----        -----          -----               -----       -----       -----        -----
   NebulaX                                       NXKApp     NXKPage      NXKView    NXKNavigation
                            NXAAppSession
   -----        -----          -----               -----       -----       -----        -----
 
 NXAAppSession: RVASession概念同级 + 部分原老容器H5Session逻辑
 */
@class NXEEngine;
@interface NXAAppSession : RVASession

// newly Propertied
@property(nonatomic, strong) UIViewController<ViewControllerProtocol> *controller;
@property(nonatomic, strong) NSString *appId;

//新容器里消灭了H5Session，H5Session的部分逻辑无法完全移动到这里，先在AppSession持有一下
@property (nonatomic, strong) id nxiDelegate;

@property(nonatomic, strong) NSMutableArray *plugins;

- (instancetype)initWithContext:(NXAAppContext *)context;
- (void)loadDataSourceForApps:(NSArray *)arrApps;
@end
