//
//  NBConfigOverwriter
//  NebulaSDK
//
//  Created by 张光宇 on 2019/5/17.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import <APMobileFramework/APMobileFramework.h>

NS_ASSUME_NONNULL_BEGIN

@protocol NBInsideService <DTService>

/**
 *  [DTBootPhase setupNavigationController]方法会回调该方法，接入应用可以创建自定义的UINavigationController。
*/
- (UINavigationController *)createNavigationController;


/**
 *  [DTBootPhase setupWindow]方法会回调到该方法，接入应用可以创建自定义的UIWindow。
 */
- (UIWindow *)createWindow;

/**
 *  gps坐标转换为高德坐标系
 */
- (CLLocationCoordinate2D)convertGPSToAMapCoordinate:(CLLocationCoordinate2D)coordinate;

@end

/*
 * 三处私有API调用，业务方需自行实现，详见文档：
 * https://yuque.antfin-inc.com/zhushi/inside/private_api
 */
//1.1网络拦截，外部实现此函数
BOOL NBInsideHandlerOnePointOne();
//1.2闪退修复 Swizzle NSURLConnection#initWithRequest:delegate:startImmediately
NSArray * NBInsideHandlerOnePointTwo();
//1.3Cookie同步
BOOL NBInsideHandlerOnePointThree(NSHTTPCookieStorage *cookieStorage);

NS_ASSUME_NONNULL_END
