//
//  NSObject+MPMPAASEnvironment.h
//  MPSecurityAdapter
//
//  Created by yemingyu on 2020/11/11.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface NSObject (MPMPAASEnvironment)
        
/// 添加截屏监听
/// @param observer 监听者
/// @param screenCapture 截屏发生时触发 screenCapture
- (void)addScreenCaptureObserver:(id)observer selector:(SEL)screenCapture;


/// 去除截屏监听
/// @param observer 监听者
- (void)removeScreenCaptureObserver:(id)observer;


/// 添加录屏监听 iOS 11.0 及以后有效，可通过 @available(iOS 11.0, *) 判定
/// @param observer 监听者
/// @param screenCapture 录屏发生时触发 screenCapture，在 screenCapture 中通过 [UIScreen mainScreen].isCaptured 判断录屏状态（YES 为录屏，NO 为没有录屏）
- (void)addScreenRecordObserver:(id)observer selector:(SEL)screenCapture;


/// 去除录屏监听
/// @param observer 监听者
- (void)removeScreenRecordObserver:(id)observer;

@end

NS_ASSUME_NONNULL_END
