//
//  MPOcrScanSession.h
//  MPOcr
//
//  Created by shifei.wkp on 2020/1/7.
//  Copyright © 2020 alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class MPOcrConfiguration;
@class MPOcrScanSession;

typedef void(^MPOcrPrepareCompletion)(MPOcrScanSession * _Nullable session,
                                      NSError * _Nullable error);


@interface MPOcrScanSession : NSObject

@property (nonatomic, readonly) BOOL isCameraRunning;           // 是否相机运行
@property (nonatomic, weak) id<MPOcrManagerDelegate> delegate;  // 扫描识别结果回调

/// 准备session，加载模型
/// @param configuration 配置
/// @param block 回调
+ (void)prepareSessionWithConfiguration:(MPOcrConfiguration *)configuration
                      completionHandler:(MPOcrPrepareCompletion)block;

/// 相机的预览视图
/// @param frame 相机frame
- (UIView *)previewOverlayViewWithFrame:(CGRect)frame;

/// 开始扫描
- (void)startSession;

/// 结束扫描
- (void)stopSession;

/// 是否支持照明
- (BOOL)isTorchSupport;

/// 设置照明状态
/// @param onMode YES:开启; NO:关闭
- (void)setTorchMode:(BOOL)onMode;

@end

NS_ASSUME_NONNULL_END
