//
//  MPOcrResult.h
//  MPOcr
//
//  Created by shifei.wkp on 2019/2/14.
//  Copyright © 2019 alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, MPOcrStatus) {
    MPOcrStatusSuccess = 0,                 // 识别成功
    MPOcrStatusUserCancel = 1,              // 用户取消
    MPOcrStatusNoCameraPermission = 101,    // 无相机权限
    MPOcrStatusEngineInitFailure = 102,     // 识别引擎初始化失败
    MPOcrStatusProcessFailure = 103,        // 识别失败
    MPOcrStatusProcessNotReady = 104,       // 流程未就绪（可能由于未获取到模型）
    MPOcrStatusConfigurationInvalid = 105,  // 配置无效（保证modelId和bizType传值正确）
};


@interface MPOcrResultItem : NSObject

@property (nonatomic, strong) NSString* label;              // 标签
@property (nonatomic, assign) float confidence;             // 置信值分数
@property (nonatomic, assign) CGRect detectBoundingBox;     // 目标的区域（检测类型的返回结果）

@end

@interface MPOcrResult : NSObject

@property (nonatomic, assign) MPOcrStatus status;                   // 结果状态
@property (nonatomic, strong) NSString* message;                    // 结果描述信息
@property (nonatomic, strong, nullable) NSArray<MPOcrResultItem *>* ocrItems;   // 结果数组
@property (nonatomic, strong, nullable) UIImage* roiCropImage;      // roi 区域截取图片（如：银行卡整张图片）
@property (nonatomic, strong, nullable) UIImage* ocrResultImage;    // ocr 识别结果图片（如：银行卡卡号区域图片）
@property (nonatomic, strong, nullable) UIImage* ocrFullImage;      // ocr 整帧图片

@end

NS_ASSUME_NONNULL_END
