//
//  MPOcrOption.h
//  MPOcr
//
//  Created by shifei.wkp on 2020/2/25.
//  Copyright © 2020 alipay. All rights reserved.
//

#ifndef MPOcrOption_h
#define MPOcrOption_h

typedef NSString * MPOcrOption NS_EXTENSIBLE_STRING_ENUM;
typedef NSString * MPOcrScene NS_EXTENSIBLE_STRING_ENUM;

// 扩展参数
/** 场景 - MPOcrScene 类型，取值参考各场景值 （用于决定识别流程） */
FOUNDATION_EXTERN MPOcrOption const kMPOcrOptionSceneKey;
/** 置信度阈值 - 数字类型，取值 0 到 1 （用于筛选识别结果） */
FOUNDATION_EXTERN MPOcrOption const kMPOcrOptionConfidenceThresholdKey;
/** 输入物体的面 - 字符串类型，取值 0: 正面；1:反面 （如身份证的正反面） */
FOUNDATION_EXTERN MPOcrOption const kMPOcrOptionInputSideKey;
/** 输入图片的方向 - 数字类型，取值 1: AVCaptureVideoOrientationPortrait;2:AVCaptureVideoOrientationPortraitUpsideDown; 3:AVCaptureVideoOrientationLandscapeRight; 4:AVCaptureVideoOrientationLandscapeLeft */
FOUNDATION_EXTERN MPOcrOption const kMPOcrOptionImageRotationKey;



// 场景选项
FOUNDATION_EXTERN MPOcrScene const kMPOcrSceneDefault;      // 默认场景
FOUNDATION_EXTERN MPOcrScene const kMPOcrSceneBankCard;     // 银行卡识别场景
FOUNDATION_EXTERN MPOcrScene const kMPOcrSceneIDCard;       // 身份证识别场景
FOUNDATION_EXTERN MPOcrScene const kMPOcrScenePassPort;       // 护照识别场景
FOUNDATION_EXTERN MPOcrScene const kMPOcrSceneCarLicense;       // 车牌识别场景
FOUNDATION_EXTERN MPOcrScene const kMPOcrSceneDriverLicense;    // 驾驶证识别场景
FOUNDATION_EXTERN MPOcrScene const kMPOcrSceneDrivingLicense;   // 行驶证识别场景
FOUNDATION_EXTERN MPOcrScene const kMPOcrSceneVinCode;   // vin码识别场景
FOUNDATION_EXTERN MPOcrScene const kMPOcrSceneGasMeter;   // 燃气表识别场景


FOUNDATION_EXTERN MPOcrScene const kMPOcrSceneCustomScan;   // 自定义扫描页面场景

#endif /* MPOcrOption_h */
