//
//  MPOcrManager.h
//  MPOcr
//
//  Created by shifei.wkp on 2019/2/14.
//  Copyright © 2019 alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreMedia/CoreMedia.h>

@class MPOcrConfiguration;
@class MPOcrResult;

NS_ASSUME_NONNULL_BEGIN

@protocol MPOcrManagerDelegate <NSObject>

/**
 ocr 结果回调
 
 @param result 回调结果
 */
@optional
- (void)didReceiveOcrResult:(MPOcrResult *)result;

@end


@interface MPOcrManager : NSObject

@property (readonly, strong) MPOcrConfiguration* configuration;

/// 设备是否支持（5s 以下机型不支持）
/// @param configuration 配置
+ (BOOL)isOcrSupportForConfiguration:(MPOcrConfiguration *)configuration;

/**
 创建 manager
 
 @param configuration 配置
 @return manager 实例
 */
+ (instancetype)managerWithConfiguration:(MPOcrConfiguration *)configuration
                                delegate:(id<MPOcrManagerDelegate>)delegate;

/// 执行OCR流程
/// @param navigationController 当前的导航栏控制器
- (void)processWithNavigationController:(UINavigationController *)navigationController;


/// 开放识别api 与执行OCR流程不同，需要控制相机自定义实现页面，调用一次初始化算法，然后调用处理函数处理相机输出的每帧。
/// 初始化算法
- (void)initAlgo;

/// 处理视频帧

- (MPOcrResult *)processFrame:(CGRect)cameraFrame pixelBuffer:(CVImageBufferRef)buffer;


- (MPOcrResult *)processPhoto:(UIImage *)image;


@end

NS_ASSUME_NONNULL_END
