//
//  MPOcrConfiguration.h
//  MPOcr
//
//  Created by shifei.wkp on 2019/2/14.
//  Copyright © 2019 alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MPOcrOption.h"
#import "MPOcrAlgorithm.h"
#import "MPOcrModelId.h"
#import "MPOcrCustomScanUIDataSource.h"


@protocol MPOcrCustomScanUIDataSource;

NS_ASSUME_NONNULL_BEGIN


@interface MPOcrConfiguration : NSObject

@property (nonatomic, strong) NSString* modelId;        // 模型ID
@property (nonatomic, assign) CGRect roiRect;           // roi 区域（在 view 的坐标系）
@property (nonatomic, assign) BOOL isPhoto;             // 单帧图片识别

@property (nonatomic, strong) NSDictionary* extParam;   // 扩展参数

@property (nonatomic, strong, nullable) NSDictionary* options;            // 扩展参数，参考 MPOcrOption.h 中取值
@property (nonatomic, strong, nullable) NSDictionary* algorithmParam;     // 算法参数，参考 MPOcrAlgorithm.h 中取值

@property (nonatomic, weak) id<MPOcrCustomScanUIDataSource> dataSource; // 自定义扫描页面UI数据源

/// 默认银行卡识别配置
+ (instancetype)defaultBankCardConfiguration;

/// 默认身份证识别配置
/// @param frontSide 是否为正面
+ (instancetype)defaultIDCardConfiguration:(BOOL)frontSide;

/// 默认驾驶证识别配置
/// @param frontSide 是否为正面
+ (instancetype)defaultDriverLicenseConfiguration:(BOOL)frontSide;

/// 默认行驶证识别配置
/// @param frontSide 是否为正面
+ (instancetype)defaultDrivingLicenseConfiguration:(BOOL)frontSide;

/// 默认车牌识别配置
+ (instancetype)defaultCarLicenseConfiguration;

/// 默认护照识别配置
+ (instancetype)defaultPassPortConfiguration;

/// 默认vin码识别配置
+ (instancetype)defaultVinCodeConfiguration;

/// 默认燃气表识别配置
+ (instancetype)defaultGasMeterConfiguration;

//默认身份证图片识别配置
+ (instancetype)defaultIDCardPhotoConfiguration;

//默认银行卡图片识别配置
+ (instancetype)defaultBankCardPhotoConfiguration;

//默认营业执照图片识别配置
+ (instancetype)defaultBusiinessLicencePhotoConfiguration;

@end

NS_ASSUME_NONNULL_END
