//
//  MPOcrAlgorithm.h
//  MPOcr
//
//  Created by shifei.wkp on 2020/2/25.
//  Copyright © 2020 alipay. All rights reserved.
//

#ifndef MPOcrAlgorithm_h
#define MPOcrAlgorithm_h

typedef NSString * MPOcrAlgorithmConfig NS_EXTENSIBLE_STRING_ENUM;
typedef NSString * MPOcrPresetAlgorithmName NS_EXTENSIBLE_STRING_ENUM;

/// 算法配置参数
/// 目前只有当 bizType 为 OCR 类型才需要该参数
///
/** 预置算法名称 - MPOcrPresetAlgorithmName 类型，取值参考 */
FOUNDATION_EXTERN MPOcrAlgorithmConfig const kMPOcrPresetAlgorithmNameKey;
/** 算法检测区域的最小个数 - 数字类型，取值为整数 */
FOUNDATION_EXTERN MPOcrAlgorithmConfig const kMPOcrDetectionAreaMinCountKey;
/** 算法检测区域的最大个数 - 数字类型，取值为整数 */
FOUNDATION_EXTERN MPOcrAlgorithmConfig const kMPOcrDetectionAreaMaxCountKey;


// 预置算法名称
FOUNDATION_EXTERN MPOcrPresetAlgorithmName const kMPOcrPresetAlgorithmNameBankCard;  // 银行卡识别增强算法
FOUNDATION_EXTERN MPOcrPresetAlgorithmName const kMPOcrPresetAlgorithmNameIDCard;    // 身份证识别算法

FOUNDATION_EXTERN MPOcrPresetAlgorithmName const kMPOcrPresetAlgorithmNameCarLicense;    // 车牌识别算法
FOUNDATION_EXTERN MPOcrPresetAlgorithmName const kMPOcrPresetAlgorithmNamePassPort;    // 车牌识别算法
FOUNDATION_EXTERN MPOcrPresetAlgorithmName const kMPOcrPresetAlgorithmNameVinCode;    // 车牌识别算法
FOUNDATION_EXTERN MPOcrPresetAlgorithmName const kMPOcrPresetAlgorithmNameDriverLicense;    // 车牌识别算法
FOUNDATION_EXTERN MPOcrPresetAlgorithmName const kMPOcrPresetAlgorithmNameDrivingLicense;    // 车牌识别算法
FOUNDATION_EXTERN MPOcrPresetAlgorithmName const kMPOcrPresetAlgorithmNameGasMeter;    // 车牌识别算法


#endif /* MPOcrAlgorithm_h */
