//
//  MPRecModelObject.h
//  MPModelManager
//
//  Created by shifei.wkp on 2020/2/18.
//  Copyright © 2020 alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class ModelItemPB;

@interface MPRecModelObject : NSObject

@property (nonatomic, strong) NSString* modelId;        // 模型Id
@property (nonatomic, strong) NSString* bundleName;        // 模型Id
@property (nonatomic, strong) NSString* version;        // 模型版本
@property (nonatomic, strong) NSString* type;           // 模型的类型
@property (nonatomic, strong) NSString* modelFileUrl;   // 模型文件的下载url
@property (nonatomic, strong) NSString* modelFileMd5;   // 模型文件的md5

@property (readonly) BOOL isPreview;    // 是否为预览模型

/// 初始化
/// @param item 模型信息
- (instancetype)initWithItem:(ModelItemPB *)item;

/// 初始化
/// @param dict 模型信息
- (instancetype)initWithDictionary:(NSDictionary *)dict;

/// 模型文件路径数组
- (NSArray *)modelPathArray;

/// 模型下载地址
- (NSString *)downloadPath;

/// 模型文件源路径
- (NSString *)modelFileSrcPath;

/// 模型解压地址
- (NSString *)unzipPath;

/// 转换成字典信息
- (NSDictionary *)toDictionary;

/// 是否需要下载
- (BOOL)needDownload;

/// 是否已安装
- (BOOL)isInstalled;

/// 模型是否有效
- (BOOL)isValid;

@end

NS_ASSUME_NONNULL_END
