//
//  MPModelManager.h
//  MPModelManager
//
//  Created by shifei.wkp on 2020/2/18.
//  Copyright © 2020 alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MPRecModelObject.h"
#import "MPModelMangerConfiguration.h"

NS_ASSUME_NONNULL_BEGIN

typedef void(^MPModelInfoResponse)(NSDictionary * _Nullable data, NSError * _Nullable error);
typedef void(^MPModelPrepareCompletion)(MPRecModelObject * _Nullable model, NSError * _Nullable error);
typedef void(^MPModelDownloadCompletion)(NSString * _Nullable path, NSError * _Nullable error);

@interface MPModelManager : NSObject

/// 单例
+ (instancetype)manager;

/// 查找已经安装的模型对象
/// @param modelId 模型Id
- (MPRecModelObject *)findModelById:(NSString *)modelId;

/// 查找已经安装的模型对象
/// @param modelId 模型Id
/// @param version 模型版本
- (MPRecModelObject *)findModelById:(NSString *)modelId version:(nullable NSString *)version;

/// RPC 请求模型信息
/// @param modelIdArray 请求的模型id数组，如果是全量传入 nil
/// @param param 扩展参数
/// @param block 回调
- (void)requestModelInfo:(nullable NSArray *)modelIdArray
                   param:(NSDictionary *)param
       completionHandler:(nullable MPModelInfoResponse)block;

/// 准备单个模型
/// @param modelId 模型Id
/// @param version 版本号，传 nil 表示使用最新版本
/// @param block 回调
- (void)prepareModelId:(NSString *)modelId
               version:(nullable NSString *)version
     completionHandler:(MPModelPrepareCompletion)block;

/// 下载模型并安装
/// @param models 模型对象数组
- (void)downloadModels:(NSArray<MPRecModelObject *> *)models;

/// 下载某个模型
/// @param model 模型对象
/// @param forceUpdate 是否强制更新
/// @param completionBlock 回调
- (void)downloadModel:(MPRecModelObject *)model
                force:(BOOL)forceUpdate
    completionHandler:(MPModelDownloadCompletion)completionBlock;

/// 准备预览的模型
/// @param model 模型对象
/// @param completionBlock 完成回到
- (void)preparePreviewModel:(MPRecModelObject *)model
          completionHandler:(MPModelPrepareCompletion)completionBlock;

@end

NS_ASSUME_NONNULL_END
