//
//  DTNRequestTask.h
//  MASSChannel
//
//  Created by cuinacai on 2020/5/28.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, DTNHTTPMethod)
{
    DTNHTTPMethodGET = 0,//GET方法
    DTNHTTPMethodPOST,  //POST方法
};

@interface DTNRequestTask : NSObject
@property(nonatomic,strong) NSString *url;
@property(nonatomic) DTNHTTPMethod httpMethod;
@property(nonatomic,strong) NSDictionary *extHeaders;
@property(nonatomic,strong) NSData *body;
@property(nonatomic) NSTimeInterval timeoutInterval;//请求任务超时时间单位（秒）
@property(nonatomic) NSTimeInterval waitTimeout;
@property(nonatomic,strong) NSString *bizType;
@property(nonatomic,strong) NSString *taskId;
@property(nonatomic,strong) NSString *modelName;
@property(nonatomic) BOOL   isGradual;
@property(nonatomic) BOOL   streamProgress;
@property(nonatomic) BOOL   forceNotQuic;
@property(nonatomic) BOOL   forceRetry;//可重试
@property(nonatomic,strong) NSString *protocolThird;
@property (nonatomic)BOOL   saveTicket;
@property (nonatomic)BOOL   saveTickUseTicketManager;
//目前用于返回埋点信息
@property(nonatomic,strong) NSMutableDictionary *retInfo;
//请求类型，DTN会根据这个做队列分流和限制
@property (nonatomic)int    requestType;
//continus,pageSession,ign30x后续支持
@end

@class DTNSesssionRequestTask;

@protocol SessionCallbackProtocol<NSObject>

- (void)dtnRequestTaskStartExcute:(DTNSesssionRequestTask*)dtnRequestTask;

- (void)dtnRequestTask:(DTNSesssionRequestTask*)dtnRequestTask
      responseHeaders:(NSData*)headers
              extInfo:(NSDictionary*)extInfo;

- (void)dtnRequestTask:(DTNSesssionRequestTask*)dtnRequestTask didLoadData:(NSData*)data;

- (void)dtnRequestTask:(DTNSesssionRequestTask*)dtnRequestTask onCompleteError:(nullable NSError*)error userInfo:(NSMutableDictionary*)userInfo;

@end

@interface DTNSesssionRequestTask : DTNRequestTask
@property(nonatomic,strong) NSURLRequest *orgRequest;
@property(nonatomic,strong) NSString *sessionTaskId;
@property(atomic,weak) id<SessionCallbackProtocol> callback;
@property(nonatomic)int socketTimeout;
@end

@interface DTNConnectItem : NSObject
@property(nonatomic,strong) NSString *host;
@property(nonatomic)uint16_t port;
@end

NS_ASSUME_NONNULL_END
