//
//  UIViewController+FLTracker.h
//  FullLinkTracker
//
//  Created by llb on 2018/10/24.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef NS_OPTIONS(NSUInteger, FLPageEndType)
{
    FLPageEndTypeNone          = 0,
    FLPageEndTypeDidAppear     = 1,  // 系统页面显示方法回调
    FLPageEndTypeWebViewFinish = 5,  // H5容器回调
    FLPageEndTypeBizReady      = 10  // 业务回调
};

typedef NS_OPTIONS(NSUInteger, FLPageTrackType)
{
    FLPageTrackTypeNone = 0,
    FLPageTrackTypeEach = 1,
    FLPageTrackTypeLink = 2,
};

typedef NS_OPTIONS(NSUInteger, FLPageTrackState)
{
    FLPageTrackStateNone    = 0,
    FLPageTrackStateFinish  = 1,
    FLPageTrackStateEach    = 2,
    FLPageTrackStateLinkOne = 4,
};

typedef NS_OPTIONS(NSUInteger, FLPageType)
{
    FLPageTypeNone      = 0,
    FLPageTypeNative    = 1,
    FLPageTypeH5        = 2,
    FLPageTypeTiny      = 3,
};

NS_ASSUME_NONNULL_BEGIN

@interface UIViewController (FLTracker)

@property (nonatomic, readonly, strong) NSString  *fltClusterId;     // 页面id，如果是app的第一个页面则等于fltLinkId，其余为fltPageId
@property (nonatomic, readonly, strong) NSString  *fltPageId;        // 页面page id
@property (nonatomic, assign) FLPageType          fltPageType;       // 页面类型
@property (nonatomic, strong) NSString            *fltPageSpmId;     // 页面spm id
@property (nonatomic, strong) NSString            *fltLinkId;        
@property (nonatomic, strong) NSString            *fltActionId;
@property (nonatomic, assign) NSTimeInterval      fltStartTime;
@property (nonatomic, assign) NSTimeInterval      fltEndTime;
@property (nonatomic, assign) FLPageEndType       fltEndType;
@property (nonatomic, assign) FLPageTrackType     fltTrackType;
@property (nonatomic, assign) FLPageTrackState    fltTrackState;
@property (nonatomic, strong) NSMutableDictionary *fltInfo;

/**
 * 在页面的viewDidDisappear的时候，是否上报页面相关监控。
 
 * @param  vc  当前将要显示页面
 * @return YES 上报，否则不上， 默认监控返回YES
 */
- (BOOL)checkLogPageOnPageAppear:(UIViewController *)vc;
- (void)resetFullLinkInfo_ap;

@end

NS_ASSUME_NONNULL_END
