//
//  FLUtils.h
//  FullLinkTracker
//
//  Created by llb on 2018/10/31.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "UIViewController+FLTracker.h"

NS_ASSUME_NONNULL_BEGIN

@interface FLUtils : NSObject

+ (NSTimeInterval)currentMediaTimeInMS;
+ (NSString *)removeQueryParamsInUrl:(NSURL *)url;
+ (NSString *)translateReferIdToPageId:(NSString *)referId;
+ (NSString *)translateMapIntoString:(NSDictionary *)dict;
+ (NSString *)translateDeepMapIntoString:(NSDictionary *)dict;
+ (NSString *)translateListIntoString:(NSArray *)list;
+ (NSString *)translatePageType:(FLPageType)pageType;
+ (NSString *)getPageTypeFromVC:(UIViewController*)vc;
+ (NSString *)getConfigForKeyFromService:(NSString *)key;
+ (NSString *)getRealKey:(NSString*)key bizType:(NSString*)bizType;

+ (BOOL)checkStringValid:(NSString *)str;
+ (id)checkDicValid:(NSDictionary *)dic elementClass:(Class)cls defaultValue:(nullable id)defaultValue;
+ (id)checkValidForObj:(id)obj class:(Class)cls defaultValue:(nullable id)defaultValue;

@end

NS_ASSUME_NONNULL_END
