//
//  FLExceptionDiagnoseHandler.h
//  FullLinkTracker
//
//  Created by shuoguang on 2019/1/28.
//  Copyright © 2019年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface FLExceptionDiagnoseHandler : NSObject

@property (nonatomic, strong, readonly) NSString* key;

- (instancetype)initWithKey:(NSString*)key;

/**
 * 启动诊断，业务继承基类自行处理逻辑。
 * @param info 配置的诊断信息
 */
- (void)onStart:(FLDiagnoseInfo*)info;

/**
 * 结束诊断，业务继承基类自行处理逻辑。
 * @param info 配置的诊断信息
 */
- (void)onEnd:(FLDiagnoseInfo*)info;

/**
 * 获取诊断结果，业务继承基类自行处理逻辑。
 */
- (NSDictionary*)getResult;

@end

NS_ASSUME_NONNULL_END
