//
//  FLException.h
//  FullLinkTracker
//
//  Created by llb on 2019/1/9.
//  Copyright © 2019年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
@class FLBlockExceptionTraceInfo;

typedef NS_OPTIONS(NSUInteger, FLExceptionType)
{
    kFLExceptionTypeDefault = 0,    // 不确定业务影响，正常级别
    kFLExceptionTypeNotFeel = 100,  // 业务可正常，但用户不感知，正常级别
    kFLExceptionTypeFeel    = 1000, // 业务可正常，但用户可以感知，高级别
    kFLExceptionTypeNotUse  = 2000, // 业务不正常使用，高级别
};

NS_ASSUME_NONNULL_BEGIN

@interface FLException : NSObject

@property (nonatomic, strong) NSString *name;               // 异常Id
@property (nonatomic, assign) FLExceptionType type;         // 异常类型
@property (nonatomic, strong) NSNumber *code;               // 错误码
@property (nonatomic, strong) NSString *reason;             // 异常原因
@property (nonatomic, strong) NSString *biz;                // 所属业务(请传入三级架构域的宏 MARK_POINT_INFO)
@property (nonatomic, strong) NSString *subBiz;             // 所属子业务
@property (nonatomic, strong) NSString *appId;              // 所属App
@property (nonatomic, strong) NSString *pageId;             // 所属页面
@property (nonatomic, strong) NSDictionary *userInfo;       // 自定义信息
@property (nonatomic, strong) NSDictionary *diagnoseInfo;   // 诊断信息
@property (nonatomic, strong) NSDictionary *traceInfo;      // 回溯信息
@property (nonatomic, strong) NSArray *callStackInfo;       // 调用栈信息
@property (nonatomic, strong) NSArray *pagesInfo;           // 页面栈信息

/**
 * 初始化对象
 * 注意必填项biz  请传入三级架构域的宏 MARK_POINT_INFO！
 */
- (instancetype)initWithName:(NSString *)name
                        type:(FLExceptionType)type
                         biz:(NSString *)biz
                      subBiz:(nullable NSString *)subBiz
                      reason:(nullable NSString *)reason
                        code:(nullable NSNumber *)code
                    userInfo:(nullable NSDictionary *)userInfo;

- (void)addBlockExceptionTraceInfo:(FLBlockExceptionTraceInfo*)traceInfo;

@end

NS_ASSUME_NONNULL_END
