//
//  FLDiagnoseHandler.h
//  FullLinkTracker
//
//  Created by shuoguang on 2018/12/17.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FLDiagnoseInfo.h"

typedef NS_ENUM(NSUInteger, FLDiagnoseErrorCode){
    FLDiagnoseErrorCodeTimeout = 1,     //超时
    FLDiagnoseErrorCodePageIdError      //执行end、cancel操作c时传入的pageId有问题
};

@interface FLDiagnoseHandler : NSObject

@property (nonatomic, strong, readonly) NSString* key;

- (instancetype)initWithKey:(NSString*)key;

/**
 * 启动诊断，启动时会判断当前是否有正在诊断中的任务。
 * 如果有，则直接返回，如果没有，才调用onStart函数传递给业务执行。
 * 每一次诊断会有超时时间，默认60s
 * @param info 配置的诊断信息
 */
- (void)start:(FLDiagnoseInfo*)info;

/**
 * 结束诊断
 * @param info 配置的诊断信息
 */
- (void)end:(FLDiagnoseInfo*)info;

/**
 * 取消诊断
 * @param info 配置的诊断信息
 */
- (void)cancel:(FLDiagnoseInfo*)info;

/**
 * 诊断出错处理
 * @param errorCode 错误码
 */
- (void)error:(NSUInteger)errorCode;

/**
 * 上报诊断信息
 * @param value 业务需要上报的诊断信息
 * @param info 添加上报到的页面信息，pageId不能为空，否则会回调onError函数
 */
- (void)logDiagnose:(NSString*)value info:(FLDiagnoseInfo*)info;

@end
