//
//  BEEDesktopShortcut.h
//  BeeUtils
//
//  Created by niki on 2019/1/4.
//  Copyright © 2019年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

// 通用创建桌面快捷方式

@interface BEEShortCutModel : NSObject

@property (nonatomic, strong) NSString *appId;
@property (nonatomic, strong) NSString *scheme;
@property (nonatomic, strong) NSString *appName;
@property (nonatomic, strong) NSString *appIcon;
@property (nonatomic, strong) NSString *appUrl;
@property (nonatomic, strong) NSString *extraStr; // 扩展参数，格式如："&sourceId=xxxx"
@property (nonatomic, strong) NSString *shortcutUrl; // 可填，定制化跳转承接页链接，支付宝有默认承接页

@end

@interface BEEDesktopShortcut : NSObject

// appId 与 schema不可同时为空
+ (BOOL)createDesktopShortcutWithModel:(void(^)(BEEShortCutModel *model))block;

@end

NS_ASSUME_NONNULL_END
