//
//  BEEBankCardIconService.h
//  BeeViews
//
//  Created by jianzwang on 15/02/2017.
//  Copyright © 2017 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>


#define KBEEChannelIconAddBankCard @"AP_ADDBANKCARD"//添加银行卡
#define KBEEChannelIconBalance @"AP_BALANCE"//余额
#define KBEEChannelIconHUABEI @"AP_HUABEI" //花呗
#define KBEEChannelIconHUABEIFQ @"AP_HUABEI_FENQI" //花呗分期
#define KBEEChannelIconYEB @"AP_YEB" //余额宝
#define KBEEChannelIconQMF @"AP_QMF" //亲密付
#define KBEEChannelIconDF @"AP_DF" //代付
#define kBEEChannelIconHuaBEIFQ_2 @"AP_HUABEI_FQ" //新的花呗分期


@interface BEEChannelIconService : NSObject

//取不到图的时候展位图，默认([UIImage imageNamed:[NSString stringWithFormat:@"%@/%@", @"BankcardIcon.bundle", @"bankDefaultIcon"]])
@property (nonatomic,strong) UIImage *defaultIcon;

/**
 * @param channel: 余额:KBEEChannelIconBalance
                   添加银行卡:KBEEChannelIconAddBankCard
                   银行机构号
 *
 * @param size: 期望的大小
 * @return 返回图片，同步返回
 */
-(UIImage *)imageForChanel:(NSString* )channel size:(CGSize)size;


+(UIImage *)imageClassForChannel:(NSString *)channel size:(CGSize) size;


+(NSString *)urlForChannel:(NSString *)channel size:(CGSize)size;
/**
 * 如果找不到图片，返回空
 *
 */
+(UIImage *)imageClassForChannelIfExist:(NSString *)channel size:(CGSize) size;

+(UIImage *)defaultChannelImage;
+(void) clearChannelIconServiceIfNeeded;

@end

