//
//  BEEVideoTrimmerView.h
//  BEEVideoTrimmer
//
//  Created by muqiao.hyk on 17/2/13.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AVFoundation/AVFoundation.h>

@protocol BEEVideoTrimmerDelegate;

NS_ASSUME_NONNULL_BEGIN

@interface BEEVideoTrimmerView : UIView

// Video to be trimmed
@property (strong, nonatomic, nullable) AVAsset *asset;

// Theme color for the trimmer view
@property (strong, nonatomic) UIColor *themeColor;

// Maximum length for the trimmed video
@property (assign, nonatomic) CGFloat maxLength;

// Minimum length for the trimmed video
@property (assign, nonatomic) CGFloat minLength;

// Customize color for tracker
@property (strong, nonatomic) UIColor *trackerColor;

// Custom image for the left thumb
@property (strong, nonatomic, nullable) UIImage *leftThumbImage;

// Custom image for the right thumb
@property (strong, nonatomic, nullable) UIImage *rightThumbImage;

// Custom width for the top and bottom borders
@property (assign, nonatomic) CGFloat borderWidth;

// Custom width for thumb
@property (assign, nonatomic) CGFloat thumbWidth;

// Custom width for frame
@property (assign, nonatomic) CGFloat frameWidth;

@property (weak, nonatomic, nullable) id<BEEVideoTrimmerDelegate> delegate;

- (instancetype)initWithFrame:(CGRect)frame NS_UNAVAILABLE;

- (nullable instancetype)initWithCoder:(NSCoder *)aDecoder NS_DESIGNATED_INITIALIZER;

//- (instancetype)initWithAsset:(AVAsset *)asset;

- (instancetype)initWithFrame:(CGRect)frame asset:(AVAsset *)asset NS_DESIGNATED_INITIALIZER;

- (void)resetSubviews;

- (void)seekToTime:(CGFloat)startTime;
- (void)seekToTime:(CGFloat)time animation:(BOOL)animation;

- (void)resetStartTime:(NSTimeInterval)startTime;

//- (void)hideTracker:(BOOL)flag;

@end

NS_ASSUME_NONNULL_END

@protocol BEEVideoTrimmerDelegate <NSObject>
- (void)trimmerViewWillChangeLeftPosition:(CGFloat)startTime rightPosition:(CGFloat)endTime;
- (void)trimmerViewDoingChangeLeftPosition:(CGFloat)startTime rightPosition:(CGFloat)endTime;
- (void)trimmerViewDidChangeLeftPosition:(CGFloat)startTime rightPosition:(CGFloat)endTime;
@end


