//
//  BEEPhotoPicker.h
//  BEEPhotoPicker
//
//  Created by Yanzhi on 15/4/19.
//  Copyright (c) 2015年 Alipay. All rights reserved.
//
//  Help Document: http://gitlab.alibaba-inc.com/BeeHive/BeePhotoPicker/blob/master/APPhotoPickerLoader.md

#import <UIKit/UIKit.h>
//#import <BEEPhotoPicker/BEEAssetProtocol.h>
#import "BEEAssetProtocol.h"
#import <APMultimedia/APMultimedia.h>
#import "BEEPhotoPickerForSPM.h"
#import "BeeFilmAlbumData.h"
#import <AntUI/AntUI.h>
#import <APMVideo/APVideoRequest.h>

//
#define kButtonTitleCamera __TEXT(@"BeePhotoPicker", @"BeePhotoPicker:拍摄", @"拍摄")
#define kButtonTitleAssets __TEXT(@"BeePhotoPicker", @"BeePhotoPicker:从相册选择", @"从相册选择")

@class BEEAssetData;

typedef enum : NSUInteger {
    BEEPhotoPickerSceneCamera = 1,
    BEEPhotoPickerSceneAssets = 1 << 1,
    BEEPhotoPickerSceneQuickAssets = 1 << 2,
    BEEPhotoPickerSceneDirectPreview = 1 << 3,
    BEEPhotoPickerSceneRemote = 1 << 4,
} BEEPhotoPickerScene;

// 定义选择图片的错误码
typedef enum : NSUInteger {
    BEEPhotoPickerErrorSuccess,                  // 成功
    BEEPhotoPickerErrorCameraNoAccess,           // 获取相机授权失败
    BEEPhotoPickerErrorCameraNotSupport,         // 该设备不支持相机
    BEEPhotoPickerErrorAssetLibraryNoAccess,     // 获取相册授权失败
    BEEPhotoPickerErrorAssetLibraryNoPhotos,     // 相册中没有照片
} BEEPhotoPickerError;



//
@protocol BEEPhotoPickerDelegate <NSObject>
@optional

/**
 * @desc 选择照片时，选择或者取消选择图片后回调
 * @param asset the asset be selected or deselected
 */
- (void)photoPickerController:(id)picker didPickAssets:(NSArray<id<BEEAssetProtocol>> *)assets;
- (void)photoPickerController:(id)picker didUnpickAssets:(NSArray<id<BEEAssetProtocol>> *)assets;

/**
 * @desc 拍照、涂鸦或者美颜完成之后的回调，此时选择照片的ViewController尚未Dismiss；当采用预选取模式时，则picker为nil。
 * 拍照或者支持涂鸦、美颜时，必须实现该接口接收返回数据；
 * @param photos NSArray of BEEAssetData
 */
- (void)photoPickerController:(id)picker didFinishPickingAssetData:(NSArray<BEEAssetData *> *)data;

/**
 * @desc 选择照片完成之后的回调，此时选择照片的ViewController尚未Dismiss；当采用预选取模式时，则picker为nil。
 * 仅从相册选取照片，实现该接口。
 * @param assets NSArray of id<BEEAssetProtocol>
 * @param theOriginal BOOL, Pick the Original Photo
 */
- (void)photoPickerController:(id)picker didFinishPickingAssets:(NSArray<id<BEEAssetProtocol>> *)assets theOriginal:(BOOL)theOriginal;

/**
 * @desc 选择照片完成之后的回调，此时选择照片的ViewController尚未Dismiss；当采用预选取模式时，则picker为nil。
 * 仅从相册选取照片，实现该接口。
 * @param source 选取的图片或视频的来源：快速、相册、拍摄
 * @param assets NSArray of id<BEEAssetProtocol>
 * @param theOriginal BOOL, Pick the Original Photo
 */
- (void)photoPickerController:(id)picker didFinishPickingAssets:(NSArray<id<BEEAssetProtocol>> *)assets
                  theOriginal:(BOOL)theOriginal source:(BEEPhotoPickerScene)source;

/**
 * @desc 视频创作-影集素材选择完成之后的回调，此时选择照片的ViewController尚未Dismiss。
 * 影集场景，必须实现该接口接收返回数据；
 * @param photos NSArray of BeeFilmAlbumData
 */
- (void)photoPickerController:(id)picker didFinishPickingFilmAlbumData:(NSArray<BeeFilmAlbumData *> *)data;

/**
 * @desc 视频创作-一键成片选择完成之后的回调，此时选择照片的ViewController尚未Dismiss。
 * 一键成片场景，必须实现该接口接收返回数据；
 * @param photos NSArray of BeeFilmAlbumData
 */
- (void)photoPickerController:(id)picker didFinishPickingFilmAlbumSmartEditData:(NSArray<BeeFilmAlbumData *> *)data;

/**
 * @desc 视频创作-影集素材选择，点击托盘item后的回调
 * 影集场景
 * 返回YES - 业务处理；返回NO - 相册默认处理，跳全屏预览
 * @param photos NSArray of BeeFilmAlbumData
 */
- (BOOL)photoPickerController:(id)picker previewAssetWithFilmAlbumData:(BeeFilmAlbumData *)data;

/**
 * @desc 业务方需要在后台压缩图片过程时一起处理其他逻辑，实现这个方法。
 *
 * 注意：在非主线程中调用
 *
 * @param assets 选中的id<BEEAssetProtocol>数组
 * @param data NSArray Of BEEAssetData
 *
 * @return
 */
- (void)photoPickerController:(id)picker processingAssets:(NSArray<id<BEEAssetProtocol>> *)assets data:(NSArray<BEEAssetData *> *)data;

/**
 * @desc 取消选择照片
 * @param error 取消选择照片的错误类型，参见<BEEPhotoPickerError>
 */
- (void)photoPickerControllerWillCancel:(id)picker withError:(BEEPhotoPickerError)error;
- (void)photoPickerControllerDidCancel:(id)picker withError:(BEEPhotoPickerError)error;

/**
 * @desc 照片选择完成，选择照片的VC即将Dismiss
 */
- (void)photoPickerControllerWillDismiss:(id)picker;

/**
 * @desc 照片选择完成，并且选择照片的ViewController已经Dismiss
 */
- (void)photoPickerControllerDidFinish:(id)picker;
- (void)photoPickerControllerDidFinish:(id)picker assets:(NSArray<id<BEEAssetProtocol>> *)assets;

/**
 * @desc 压缩操作相关的回调：如果实现了start协议，并且返回YES，将执行组件封装的压缩操作，如果返回NO，将不执行组件的压缩操作，由业务方自己实现压缩操作；压缩完成时将回调endCompressWithVideo
 */
- (BOOL)photoPickerController:(id)picker startCompressVideo:(id<BEEAssetProtocol>)videoAsset orData:(BEEAssetData *)data;
- (void)photoPickerController:(id)picker endCompressWithVideo:(BEEAssetData *)videoInfo orError:(NSError *)error;
/**
 * @desc 视频时长裁剪操作相关的回调：如果实现了该协议，只会回调clip的起始/结束时间，不会做压缩操作
 */
- (void)photoPickerController:(id)picker handleVideo:(id<BEEAssetProtocol>)videoAsset clipWithStart:(NSTimeInterval)startTime end:(NSTimeInterval)endTime;

/**
 * @desc 照片选择页面点击了视频按钮
 */
- (void)photoPickerDidClickCameraAction;

/**
 * @desc 照片选择页面的视频按钮是否等于返回
 */
- (BOOL)photoPickerCameraActionEqualToBack;

/**
 * @desc 照片选择页面进入一键成片混排界面
 */
- (void)photoPickerDidCombinationAction:(id)picker
                 filmAlbumSmartEditData:(NSArray<BeeFilmAlbumData *> *)datas
                     maximumVideoLength:(CGFloat)maximumVideoLength
                     minimumVideoLength:(CGFloat)minimumVideoLength;

@end



//
@interface BEEPhotoPicker : NSObject
@property (nonatomic, assign) BOOL justPickVideo;                       // 是否只要选择视频,Default NO.不支持快速选择
@property (nonatomic, assign) BOOL enablePickVideo;                     // 是否支持选择视频,Default NO.
@property (nonatomic, assign) BOOL enableMultipleVideo;                 // 是否支持选择多个视频,Default NO.
@property (nonatomic, assign) BOOL isExclusionary;                      // 是否选择照片与视频互斥，Default YES.
@property (nonatomic, assign) CGSize sizeLimit;                         // 尺寸限制

@property (nonatomic, assign) BOOL enablePickGif;                       // 是否支持选择Gif图片,Default NO.Gif作为静态图使用
@property (nonatomic, assign) BOOL enablePickGifMix;                    // 是否支持混选Gif图片,Default NO.与静态图片混合选择
@property (nonatomic, assign) NSUInteger maximumGifSize;                // 最大可选Gif图片大小，Default 5M（5*1024*1024）

@property (nonatomic, assign) BOOL enableQuickPick;                     // 是否可快速选择 Default NO
@property (nonatomic, assign) BOOL enablePhotoPreview;                  // 是否允许图片预览 Default YES
@property (nonatomic, assign) BOOL enableSelectButton;                  // 是否显示选择CheckButton Default YES
@property (nonatomic, assign) BOOL enableSerialNumber;                  // 是否显示选择序号 Default NO
@property (nonatomic, assign) BOOL enableOriginPhotoForSelectOne;       // 发送单张图片时，是否需要原图 Default NO
@property (nonatomic, assign) BOOL enableEditingToCamera;               // 拍照时，是否可以编辑照片 Default NO
@property (nonatomic, assign) BOOL enterGridViewFirst;                  // 从相册选择时，使用先进入相册列表，default=NO
@property (nonatomic, assign) BOOL enableSysNaviInPreview;              // 预览时是否使用系统导航栏，default=NO
@property (nonatomic, assign) BOOL enableBottomViewInPreview;           // 预览时是否显示底部的选择按钮 Default NO
@property (nonatomic, assign) BOOL hidePickOriginControl;               // 隐藏选择原图的控件 Default NO
@property (nonatomic, assign) BOOL pickOriginChecked;                   // 选择原图控件是否选中，Default NO
@property (nonatomic, assign) BOOL hideProcessingIndicator;             // 隐藏处理图片时的菊花 Default NO
@property (nonatomic, assign) BOOL useFrontCamera;                      // 使用相机拍照时，是否默认是否前置摄像头 Default NO
@property (nonatomic, assign) BOOL fixOrientation;                      // 自动修正照片方向 Default YES
@property (nonatomic, assign) BOOL noAnimationForDismissAssetPicker;    // 隐藏从相册选图界面时，是否使用动画 Default NO
@property (nonatomic, assign) BOOL enableTapAssetToSend;                // 选择一张图片时，单击图片则发送 Default YES
@property (nonatomic, assign) BOOL enableDoodle;                        // 是否允许涂鸦，default=NO
@property (nonatomic, assign) BOOL enablePickAssetInCloud;              // 是否支持iCloud图片(未同步到本地)选择，default=YES
@property (nonatomic, assign) BOOL shouldSyncAssetInCloud;              // 是否需要下载iCloud图片，default=NO
@property (nonatomic, assign) BOOL saveToAlbum;                         // 是否保存到相册 默认保存 拍照模式设置有效
@property (nonatomic, assign) CGFloat beautyLevel;                      // 美颜级别选项（0~1），0-不美颜
@property (nonatomic, strong) NSString *confirmButtonTitle;             // 确定按钮的标题
@property (nonatomic, strong) NSArray *previewAssetArray;               // 直接预览选择图片时带入数据源 NSArray Of PHAsset/ALAsset
@property (nonatomic, strong) NSArray<NSString *> *selectedAssetKeys;   // 设置需要被预先选中的照片，请优先设置MaximumSelected
@property (nonatomic, assign) NSInteger maxImageSize;                   // 最大可选照片的大小，Default 0（不限制）

@property (nonatomic, assign) BOOL enableEditVideo;                     // 是否支持选择视频剪辑,Default NO.
@property (nonatomic, assign) BOOL enableVideoFilter;                   // 是否支持视频编辑添加滤镜, Default NO.
@property (nonatomic, assign) BOOL isShowVideoTimeIndicator;            // 视频剪辑是否显示时间,Default false.
@property (nonatomic, assign) CGFloat maximumVideoLength;               // 视频剪辑后最大时长,Default 10s. 开启编辑生效
@property (nonatomic, assign) CGFloat minimumVideoLength;               // 视频剪辑后最小时长,Default 1s. 开启编辑生效
@property (nonatomic, assign) APVideoCompressLevel videoCompressLevel;  // 视频压缩等级(low-360P，mid-540P，high-720P)
@property (nonatomic, assign) NSInteger maxVideoSize;                   // 最大可选视频的大小，Default 0（不限制）
@property (nonatomic, assign) BOOL enableVideoClipCompress;             // 视频裁剪时是否压缩，Default YES
@property (nonatomic, assign) BOOL openVideoClipWithPresent;            // 打开视频裁剪页面的方式，Default YES

@property (nonatomic, copy) NSString *showBottomToolView;             // 是否显示底部工具栏，传true和false， （由于photoBrowser里的参数showBottomToolView有默认逻辑，如果要自己定制，得确定是从外部传进来的，所以这里用string，而不是bool，不然就走默认的逻辑)
@property (nonatomic, assign) BOOL enableTitleConfirmButton;            // 是否需要顶部确认按钮（10.2.30版本扫一扫需要）Default NO
@property (nonatomic, strong) NSString *titleConfirmButtonTitle;        // 顶部确定按钮的标题（10.2.30版本扫一扫需要），必须要enableTitleConfirmButton为YES才生效
@property (nonatomic, strong) NSString *photoBrowserSpmExtra;           // 相册业务埋点扩展参数

@property (nonatomic, copy) NSString *remoteActionTitle;                // 从服务端选图片时，需要设置，如果不设置，actionsheet将不展示服务端选图的item
@property (nonatomic, copy) NSArray *remoteSources;                     // 服务端图片源

@property (nonatomic, assign) NSInteger useNewPicker;                   // 选图页面新老方案切换: 0-老方案，1-新方案
@property (nonatomic, copy) NSString *bizType;                          // 业务bizType;
@property (nonatomic, copy) NSDictionary *spmIdDic;                     // 支持的key在 BEEPhotoPickerForSPM.h
@property (nonatomic, copy) NSDictionary *spmPageInfo;                  // 页面的spm参数

@property (nonatomic, strong) NSMutableArray<BeeFilmAlbumData *> *filmAlbumData; // 影集素材数据
@property (nonatomic, assign) NSUInteger filmAlbumMinDataCount;         // 影集素材最小个数，低于这个数按钮不可用

@property (nonatomic, assign) BOOL smartEdit;                           // 是否开启一键成片
@property (nonatomic, assign) BOOL smartEditOnlyVideo;                  // 是否一键成片只生成video
@property (nonatomic, assign) BOOL enableCamera;                        // 是否显示相机入口

//10.3.80 新增appId白名单，设置调用相机拍照时，不抢占音频焦点
@property (nonatomic, copy) NSString *appId;

+ (BEEPhotoPicker *)sharedPicker;

/** @desc 设置最大可选图片数量 Default=9 */
- (void)setMaximumSelected:(NSUInteger)count;
// 选择多个视频场景时可设置视频最大可选数，Default 1.
- (void)setMaxVideoSelected:(NSUInteger)count;
/** @desc 设置混选可选图片数量 Default=9 */
- (void)setMaximumImageVideoSelected:(NSUInteger)count;

/** @desc 隐藏“正在处理...”菊花 */
- (void)setProcessingIndicatorHidden;

/**
 * @Description 显示图片选择控件。当scene只有一个场景时，直接显示拍照（或相册）视图；当scene有两个或以上场景时，使用UIActionSheet弹出选择窗口
 * 支持iPhone和iPad
 */
- (void)showPhotoPickerFromRect:(CGRect)frame
                      withScene:(BEEPhotoPickerScene)scene
                       delegate:(id)delegate;

/**
 * @Description 显示图片选择控件。当scene只有一个场景时，直接显示拍照（或相册）视图；当scene有两个或以上场景时，使用UIActionSheet弹出选择窗口
 * 支持iPhone和iPad
 *
 * @param viewcontroller 将图片选择界面显示在该ViewController上，当业务界面是被present出来的界面，请使用该接口
 */
- (void)showPhotoPickerFromRect:(CGRect)frame
               inViewController:(UIViewController *)viewcontroller
                      withScene:(BEEPhotoPickerScene)scene
                       delegate:(id)delegate;

/**
 * @Description 显示图片选择控件。当scene只有一个场景时，直接显示拍照（或相册）视图；当scene有两个或以上场景时，使用UIActionSheet弹出选择窗口。
 * 支持iPhone和iPad。
 * @param manuDismiss 图片选择完成之后是否自动消失。NO，不能调用dismissPhotoPickerAfterPicking；YES，需要手动调用dismissPhotoPickerAfterPicking。
 */
- (void)showPhotoPickerFromRect:(CGRect)frame
                      withScene:(BEEPhotoPickerScene)scene
                    manuDismiss:(BOOL)manuDismiss
                       delegate:(id)delegate;

/**
 * @Description 显示图片选择控件。当scene只有一个场景时，直接显示拍照（或相册）视图；当scene有两个或以上场景时，使用UIActionSheet弹出选择窗口
 * 支持iPhone和iPad
 *
 * @param viewcontroller 将图片选择界面显示在该ViewController上，当业务界面是被present出来的界面，请使用该接口
 * @param manuDismiss 图片选择完成之后是否自动消失。NO，不能调用dismissPhotoPickerAfterPicking；YES，需要手动调用dismissPhotoPickerAfterPicking。
 */
- (void)showPhotoPickerFromRect:(CGRect)frame
               inViewController:(UIViewController *)viewcontroller
                      withScene:(BEEPhotoPickerScene)scene
                    manuDismiss:(BOOL)manuDismiss
                       delegate:(id)delegate;


/** @Desc 初始化一个UIActionSheet选择窗口，由业务方自定义显示方式 */
- (AUActionSheet *)actionSheetWithScene:(BEEPhotoPickerScene)scene delegate:(id)delegate;

/** @desc 业务方主动调用，消失选图界面 */
- (void)dismissPhotoPickerAfterPicking;

/** @desc 选图结束（不是 取消），重置状态，但没有dismiss */
- (void)finishPhotoPickerAndReset;

/** @desc 清除已选中的asset */
- (void)clearPickedAssets;

/** @desc 选中的Asset资源 */
//- (NSArray *)selectedAssetArray;

/** @desc 查询相册 异步*/
- (void)fetchAssetsWithPHAssetMediaType:(PHAssetMediaType)mediaType Options:(PHFetchOptions *)options completionBlock:(void (^)(PHFetchResult *fetchResult))callback;

/** @desc 业务方主动调用，重新设置是否主动调用消失方法 */
- (void)resetManuDismissAfterPicking:(BOOL)manuDismissAfterPicking;

@end
