//
#import <Foundation/Foundation.h>

@protocol BEECollectionProtocol <NSObject>

/** @desc 每个相册的Key值，兼容iOS7/iOS8 */
- (NSString *)bee_collectionKey;

/** @desc 相册的名称 */
- (NSString *)bee_name;

/** @desc 照片的数量 */
- (NSUInteger)bee_countOfPhotos;

/** @desc 视频的数量 */
- (NSUInteger)bee_countOfVideos;

/** @desc 所有资源的数量 */
- (NSUInteger)bee_countOfAssets;

/** @desc 相册封面的缩略图 */
- (void)bee_getPosterImageWithCompletion:(void (^)(UIImage *image))completion;

@end
