//
//  BEEAssetManager.h
//  BeePhotoPicker
//
//  Created by Yanzhi on 15/12/3.
//  Copyright © 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Photos/Photos.h>
//#import <APMonitor/APAbnormalMemShortage.h>
//#import <APStability/APStability.h>

#import "BEECollectionProtocol.h"
#import "BEEAssetCommon.h"
#import "BEEAsset.h"

#define kBEEAssetLibraryDidChangedNotification @"kBEEAssetLibraryDidChangedNotification"

@protocol BEEAssetManagerProtocol <NSObject>

@optional

/**
 * @desc 相册访问权限状态
 */
- (BEEAuthorizationStatus)assetAuthStatus;

/**
 * @desc 构建系统中所有相册
 */
- (void)loadCollectionsWithCompletion:(void (^)(BOOL success))completion;

/**
 * @desc 加载某个相册中所有Assets数据
 */
- (void)loadAssetsInCollection:(NSString *)collectionKey
                    completion:(void (^)(BEELoadAssetErrorCode))completion;

/**
 * @desc 构建某个相册中，indexSet所指定的资源数据
 */
- (void)loadAssetsInCollection:(NSString *)collectionKey
                    atIndexSet:(NSIndexSet *)indexSet
                    completion:(void (^)(BEELoadAssetErrorCode))completion;

- (void)loadAllAssetKeysAndAssetsInCollection:(NSString *)collectionKey
                                     indexSet:(NSIndexSet *)indexSet
                                   completion:(void (^) (BEELoadAssetErrorCode)) completion;

/**
 * @desc 图片缓存模块
 */
- (void)startCachingImages:(NSArray *)assetKeys;        // 对应的asset为nil，则不缓存图片
- (void)cancelCachingImages:(NSArray *)assetKeys;
- (void)stopCachingImagesForAllAssets;

typedef void (^GetCachingImageBlock)(UIImage *image, BOOL isCancelled, BOOL isDegraded);
- (BEEImageRequestID)getCachingImageForAsset:(BEEAsset *)beeAsset
                                  completion:(GetCachingImageBlock)completion;
- (void)cancelGetCachingAssetImage:(BEEImageRequestID)requestID;
@end


@interface BEEAssetManager : NSObject <BEEAssetManagerProtocol>
{
    @protected
    dispatch_queue_t _assetLoadQueue;
    NSString         *_collectionKeyLoaded;  // 已经有图片加载到内存的相册，用于标识当前显示的相册
}

@property (nonatomic, copy) NSArray                 *collectionKeyArray;    // 相册key值的索引
@property (nonatomic, copy) NSDictionary            *collectionDict;        // key-value，用于快速访问数据
@property (atomic,    strong) NSMutableArray        *assetKeyArray;         // 将索引进行排序，AssetIndex
@property (nonatomic, strong) NSMutableDictionary   *assetDict;             // key-value用于快速读取数据{key, BEEAsset}

@property (nonatomic, assign) BOOL                  assetLibraryDidChanged; // 相册已经更新
@property (nonatomic, assign) BOOL                  isRefreshingAssets;     // 是否正在相册数据，防止多次相册更新通知
@property (nonatomic, assign) BOOL                  isEventLog;             // 是否已上报埋点，多次上报
@property (nonatomic, assign) BOOL                  needReload;             // 是否要重新刷新

/** 工厂方法，根据操作系统类型创建对应的AssetManager */
+ (BEEAssetManager *)createAssetManager;

/** 重置AssetManager */
- (void)resetAssetManager;

/** 注册相册更新通知 */
- (void)registPhotoChangedNotification;
/** 取消注册相册更新通知 */
- (void)unregistPhotoChangedNotification;

/** 缓存上一次选过图片的CollectionKey */
- (NSString *)lastUsedCollectionKey;
- (void)saveUsedCollectionKey;

///** override  由子类实现该方法，执行获取AssetKeys */
//- (void)processLoadAllAssetKeysInCollection:(id)collection withKeyArray:(NSMutableArray *)keyArray;

- (void)processLoadAssetsInCollection:(id)collection keyArray:(NSMutableArray *)keyArray
                            assetDict:(NSMutableDictionary *)assetDict;

- (void)processLoadAssetsInCollection:(id)collection indexSet:(NSIndexSet *)indexSet
                              keyDict:(NSMutableDictionary *)keyDict
                            assetDict:(NSMutableDictionary *)assetDict;

- (void)processLoadAllKeys:(NSMutableArray *)allKeys assets:(NSMutableDictionary *)assetDict
               tempKeyDict:(NSMutableDictionary *)tempKeyDict atIndexSet:(NSIndexSet *)indexSet
              inCollection:(id)collection;

/**
 * @desc 相册更新，数据源刷新
 */
- (void)updateCollectionAndAssetDataCompletion:(void (^)())completion;
- (void)updateAssetDataCompletion:(void (^)())completion;
- (void)doAfterUpdateAssetData;

/** @desc 根据collectionKey反查Collection */
- (id<BEECollectionProtocol>)fetchCollectionWithKey:(NSString *)collectionKey;
/** @desc 根据collectionKey反查Collection 异步*/
- (void)fetchCollectionWithKey:(NSString *)collectionKey completionBlock:(void (^)(id<BEECollectionProtocol> collection))callback;

/** @desc 查询相册 异步*/
- (void)fetchAssetsWithPHAssetMediaType:(PHAssetMediaType)mediaType Options:(PHFetchOptions *)options completionBlock:(void (^)(PHFetchResult *fetchResult))callback;

- (void)enterBackgroundWithoutBEEPhotoPicker;

- (void)forceRefreshAsset;

@end
