//
//  BEEAssetImageLoader.h
//  BeePhotoPicker
//
//  Created by Yanzhi on 15/12/9.
//  Copyright © 2015年 Alipay. All rights reserved.
//
//  Asset中包含的Image加载工具

#import <Foundation/Foundation.h>
#import "BEEAssetCommon.h"
#import "BEEAssetProtocol.h"

@interface BEEAssetImageLoader : NSObject

@property (assign, readonly)  BEEAssetSizeType  sizeType;
@property (nonatomic, strong) UIImage           *image;
@property (nonatomic, weak)   UIImageView       *requestView;       // Attention: 不要持有view，以免无法释放
@property (nonatomic, assign) BOOL              loading;            // 正在加载图片

- (BEEAssetImageLoader *)initWithSizeType:(BEEAssetSizeType)sizeType requestView:(UIImageView *)requestView;

- (void)requestImageWithAsset:(id<BEEAssetProtocol>)asset completion:(void (^)(UIImage *))completion;
- (void)cancelRequestImage:(id<BEEAssetProtocol>)asset;

@end
