//
//  BEEAsset.h
//  BeePhotoPicker
//
//  Created by Yanzhi on 15/12/9.
//  Copyright © 2015年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BEEAssetProtocol.h"
#import "BEEAssetImageLoader.h"

@interface BEEAsset : NSObject
{
    BEEAssetImageLoader *_imageLoader;
}
@property (nonatomic, strong) id<BEEAssetProtocol> asset;       // PHAsset 或者 ALAsset
//@property (nonatomic, assign) BOOL                 loading;     // 正在加载Asset元数据

/**
 * @desc 带参数初始化方法
 */
- (BEEAsset *)initWithAsset:(id<BEEAssetProtocol>)asset;

/**
 * @desc 加载当前Index所对应的Asset，当requestView参数不为nil，说明需要加载Image并显示
 */
- (void)loadImageWithSizeType:(BEEAssetSizeType)sizeType
                  requestView:(UIImageView *)requestView
                   completion:(void (^)(UIImage *image, UIImageView *requestView))completion;
- (void)cancelLoadImage;

@end
