//
//  NPTypeCheck.h
//  NebulaPlugins
//
//  Created by 慕桥(黄玉坤) on 16/10/9.
//  Copyright © 2016年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

#define TypeCheck NPTypeCheck

/*
 =========================================================================================================================
 宏 	描述
 VFSTR 	确保结果为NSString* 或其子类
 VFARRAY 	确保结果为NSArray* 或其子类
 VFDICT 	确保结果为NSDictionary* 或其子类
 VF*NUM  确保结果可以转换到对应的Number*类型.
 =========================================================================================================================
 以下几个宏用于对值进行检测, 检测不成功返回0.
 宏 	描述
 VFBOOL 	确保结果为NSNumber*, NSString* 或其子类, 且为bool类型包装
 VFINT 	确保结果为NSNumber*, NSString* 或其子类 , 且为int类型包装
 VFLLONG 	确保结果为NSNumber*, NSString* 或其子类, 且为long long类型包装
 VFFLOAT 	确保结果为NSNumber*, NSString* 或其子类, 且为float类型包装
 VFDOUBLE 	确保结果为NSNumber*, NSString* 或其子类, 且为double类型包装
 ========================================================================================================================
 */

//NSString和NSNumber要求.
#define VFSTR(value) [TypeCheck  valueForString:value]

//NSArray和NSDictionary要求
#define VFARRAY(value) [TypeCheck  valueForArray:value]
#define VFDICT(value)  [TypeCheck  valueForDictionary:value]

#define VFBNUM(value)  [TypeCheck  valueForBoolNumber:value]
#define VFINUM(value)  [TypeCheck  valueForIntNumber:value]
#define VFLLNUM(value)  [TypeCheck  valueForLongLongNumber:value]
#define VFFNUM(value)  [TypeCheck  valueForFloatNumber:value]
#define VFDNUM(value)  [TypeCheck  valueForDoubleNumber:value]

//确保符合给定类型.
#define VFBOOL(value) [TypeCheck  valueForBool:value]
#define VFINT(value) [TypeCheck  valueForInt:value]
#define VFLLONG(value) [TypeCheck  valueForLongLong:value]
#define VFFLOAT(value) [TypeCheck  valueForFloat:value]
#define VFDOUBLE(value) [TypeCheck  valueForDouble:value]

//返回确定的NSString, NSNumber或者nil
@interface TypeCheck : NSObject
+ (NSString *) valueForString:(id) value;
+ (NSNumber *) valueForBoolNumber:(id) value;
+ (NSNumber *) valueForIntNumber:(id) value;
+ (NSNumber *) valueForLongLongNumber:(id) value;
+ (NSNumber *) valueForFloatNumber:(id) value;
+ (NSNumber *) valueForDoubleNumber:(id) value;


+ (NSArray *) valueForArray:(id) value;
+ (NSDictionary *) valueForDictionary:(id) value;

//Number进一步要求, 得到值类型.
+ (BOOL) valueForBool:(id) value;
+ (int) valueForInt:(id) value;
+ (long long) valueForLongLong:(id) value;

+ (float) valueForFloat:(id) value;
+ (double) valueForDouble:(id) value;
@end
