//
//  BeeLargeMediaBiz.h
//  BeePhoto
//
//  Created by billking on 2022/5/30.
//  Copyright © 2022 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface BeeLargeMediaBiz : NSObject

typedef NS_ENUM(NSInteger,BeeLargeMediaClearType)
{
    BeeLargeMediaClearType_Once = 1,      // 启动直接清理
    BeeLargeMediaClearType_Time = 2,      // 根据expireTime清理
    BeeLargeMediaClearType_Forever = 3    // 永久不清理
};

/// 大文件存储地址
/// @param appId 业务id，用于存储隔离 
+ (NSString *)largeMediaPath:(NSString *)appId;

/// 获取当前appid对应的大文件存储文件夹
/// @param appId 业务id，用于存储隔离
/// @param needCreate 是否需要创建文件夹
+ (NSString *)largeMediaFold:(NSString *)appId needCreate:(BOOL)needCreate;

/// 插入一条大文件数据
/// @param filePath 文件地址
/// @param expireTime 过期时间，如果clearType=BeeLargeMediaClearType_Time才有效
/// @param clearType 清理策略
+ (void)insertLargeMedia:(NSString *)filePath
              expireTime:(NSNumber *)expireTime
               clearType:(BeeLargeMediaClearType)clearType;


/// 存储大文件
/// @param appId 业务id，用于存储隔离
/// @param data 要存储的数据
/// @param type 要存储的后缀名
/// @return 虚拟地址：https://largeMedia/{localId}.{type}
//+ (NSString *)createLargeMediaLocalPathWithAppId:(NSString *)appId data:(NSData *)data type:(NSString *)type;



@end

