//
//  IBeeVideoPlayer.h
//  BeeMediaPlayer
//
//  Created by manyi.zsf on 2017/3/29.
//  Copyright © 2017年 Alipay. All rights reserved.
//

typedef NS_ENUM(NSInteger, BeeVideoType) {
    BeeVideoType_ShortVideo,        //小视频
    BeeVideoType_AssetVideo,        //相册视频
    BeeVideoType_VOD,               //点播
    BeeVideoType_Live,              //直播
};

typedef NS_ENUM(NSInteger, BEEVideoPlayerState) {
    BEEVideoPlayerState_Stop,
    BEEVideoPlayerState_Playing,
    BEEVideoPlayerState_Pause,
    BEEVideoPlayerState_Loading,
};

typedef NS_ENUM(NSInteger, BeeVideoPlayerViewTag) {
    BeeVideoPlayerBtnTag_CenterPlay = 1 << 0,
    BeeVideoPlayerBtnTag_Play = 1 << 1,
    BeeVideoPlayerBtnTag_Asset = 1 << 2,
    BeeVideoPlayerBtnTag_Retry = 1 << 3,
    BeeVideoPlayerBtnTag_Close = 1 << 4,
    BeeVideoPlayerBtnTag_Muted = 1 << 5,
    BeeVideoPlayerBtnTag_FullScreen = 1 << 6,
    BeeVideoPlayerBtnTag_Continue = 1 << 7,
    BeeVideoPlayerViewTag_Control = 1 << 8,
    BeeVideoPlayerViewTag_TopBar = 1 << 9,
    BeeVideoPlayerViewTag_CenterView = 1 << 10,
    BeeVideoPlayerViewTag_BottomBar = 1 << 11,
    BeeVideoPlayerBtnTag_Quality = 1 << 12,
    BeeVideoPlayerViewTag_Quality = 1 << 13,
    BeeVideoPlayerBtnTag_Rate = 1 << 14,
    BeeVideoPlayerViewTag_Rate = 1 << 15,
};


typedef BeeVideoPlayerViewTag BeeVideoPlayerBtnTag;

// 视频渲染特效
typedef NS_OPTIONS(NSUInteger, BeeVideoPlayerRenderEffect) {
    BeeVideoPlayerRenderEffectNone        = 0,       // 原始
    BeeVideoPlayerRenderEffectTransparent = 1 << 0,  // 透明视频效果，需要播放透明视频的id
};

typedef NS_ENUM(NSInteger, BeeVideoError) {
    BeeVideoError_Unknown = 1001,      //未知错误
    BeeVideoError_Network = 1002,      //网络错误
};

#pragma mark - protocol BeeVideoPlayer

@protocol BeeVideoPlayerDelegate <NSObject>

- (void)BeeVideoPlayerStarted;
- (void)BeeVideoPlayerFinished;
- (void)BeeVideoPlayerUpdateURL;
- (void)BeeVideoPlayerDidReadyToPlay:(NSTimeInterval)totalTime;
- (void)BeeVideoPlayerPlayedTime:(NSTimeInterval)playedTime;
- (void)BeeVideoPlayerCachedTime:(NSTimeInterval)cachedTime;
- (void)BeeVideoPlayerWillSeekToTime:(NSTimeInterval)seekTime;
- (void)BeeVideoPlayerDidSeekToTime:(NSTimeInterval)seekTime;
- (BOOL)BeeVideoPlayerWillChangeState:(BEEVideoPlayerState)newState;
- (void)BeeVideoPlayerFailedWithError:(NSError *)error needHandle:(BOOL)needHandle;
- (void)BeeVideoPlayerVideoExtraInfo:(NSDictionary *)extraInfo;
- (void)BeeVideoPlayerSnapshotImage:(UIImage *)snapshot;
- (void)BeeVideoPlayerQualitySwitching:(BOOL)isSwitchEnd withError:(NSError *)error;

@end

#define kBeeVideoPlayerProperty @synthesize videoType,isAutoPlay,isAutoReplay,enableCache,isMuted,isFillScreen,placeholder,currentInterfaceOrientation,renderEffect,playbackRate,allQualityList,currentPosition,thumbnailView,videoSize,videoStorageSize,quality,displayQuality,durationWatchedInterval,isPlayFromCache,isCached,videoFPS,resourceId;


@protocol IBeeVideoPlayer <NSObject>

/// ！！！！！！！！！！！！！！！！！！！！！！！！！！！！
/// ！！！新增的属性与方法都需要respondsToSelector判断 ！！！
/// ！！！！！！！！！！！！！！！！！！！！！！！！！！！！
@required

@property (nonatomic, assign) BeeVideoType videoType;               //default is BeeVideoType_ShortVideo
@property (nonatomic, assign) BOOL isAutoPlay;
@property (nonatomic, assign) BOOL isAutoReplay;
@property (nonatomic, assign) BOOL enableCache;
@property (nonatomic, assign) BOOL isMuted;
@property (nonatomic, assign) BOOL isFillScreen;
@property (nonatomic, strong) UIImage *placeholder;         //在缩略图下载下来之前的占位图像
@property (nonatomic, strong, readonly) UIImageView *thumbnailView; //播放器当前的缩略图view
@property (nonatomic, assign) UIInterfaceOrientation currentInterfaceOrientation;
@property (nonatomic, assign, readonly) BOOL isCached;      //是否已缓存
@property (nonatomic, assign) BeeVideoPlayerRenderEffect renderEffect;
@property (nonatomic, assign, readonly) NSTimeInterval currentPosition;
@property (nonatomic, assign) CGFloat playbackRate;
@property (nonatomic, assign, readonly) CGSize videoSize;
@property (nonatomic, assign, readonly) NSInteger videoFPS;
@property (nonatomic, assign, readonly) long long videoStorageSize;
@property (nonatomic, copy, readonly) NSDictionary *logInfo;
@property (nonatomic, copy, readonly) NSArray *allQualityList;
@property (nonatomic, copy) NSString *quality; // 当前视频清晰度， 用于获取清晰度和切换清晰度
@property (nonatomic, copy) NSString *displayQuality; // 当前视频清晰度， 用于获取清晰度和切换清晰度
@property (nonatomic, assign, readonly) BOOL isPlayFromCache; // 当前视频是否在本地存在缓存
@property (nonatomic, copy) NSString *resourceId; // 资源id 用于统一降级。 需在SetVideoUrl之前设置。
@property (nonatomic, assign) BOOL enableSystemPIP; // 告知底层是否启用了系统的画中画功能

/**
 *  通过进度回调播放当前播放时长的间隔，单位为秒，默认为0.5s
 *  注意：必须在播放前设置才有用
 */
@property (nonatomic, assign) NSTimeInterval durationWatchedInterval;

- (void)setDelegate:(id<BeeVideoPlayerDelegate>)aDelegate;
- (void)play;
- (void)pause;
- (void)stop;
- (void)seekToTime:(NSTimeInterval)time;
- (void)seekEnd;
- (UIView *)displayView;
- (void)setVideoUrl:(NSString *)url withBusiness:(NSString *)business;
- (void)setVideoUrl:(NSString *)url withBusiness:(NSString *)business andExtraInfo:(NSDictionary *)extraInfo;
- (void)setVideoUrl:(NSString *)url withBusiness:(NSString *)business withReferer:(NSString *)referer andExtraInfo:(NSDictionary *)extraInfo;
- (void)updateVideoUrl:(NSString *)url;

- (void)layoutViewWithBounds:(CGRect)bounds isRotate:(BOOL)isRotate andIsFullScreen:(BOOL)isFullScreen;
- (CGPoint)getVideoPointWithPoint:(CGPoint)ptView inView:(UIView *)view;
- (void)captureVideoWithSize:(CGSize)size;

- (void)interrupt;
- (void)resume;

- (void)setLiveMinCache:(float)minCache;
- (void)setLiveMaxCache:(float)maxCache;
- (void)setInitialTime:(NSTimeInterval)initialTime;
- (NSTimeInterval)getCurrentTime;
- (void)enableBackgroundBlurEffect:(BOOL)enable;

@end
/// ！！！！！！！！！！！！！！！！！！！！！！！！！！！！
/// ！！！新增的属性与方法都需要respondsToSelector判断 ！！！
/// ！！！！！！！！！！！！！！！！！！！！！！！！！！！！
