//
//  IBeeVideoManager.h
//  BeeMediaPlayer
//
//  Created by manyi.zsf on 2017/4/26.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#ifndef IBeeVideoManager_h
#define IBeeVideoManager_h

// 带id的进度回调
typedef void (^BeeVideoProcessiveWithIdBlock)(NSString *identifier,double percentage,long long partialBytes,long long totalBytes);
typedef void (^BeeVideoUploadCompletion)(NSString *cloudId, NSError *error);
// 带id的完成回调
typedef void (^BeeVideoDownloadCompletion)(NSString *identifier,NSString *storePath,NSError *error);
typedef void (^BeeVideoDownloadImageCompletion)(NSString *identifier, UIImage *image,  NSError *error);

@protocol IBeeVideoManager <NSObject>

@optional
/**
 判断url对应的文件是否已经缓存

 @param idf
 @return YES - 已缓存；NO - 未缓存
 */
- (BOOL)isCachedWithUrl:(NSString *)url;

/**
 下载视频文件

 @param idf
 @param business
 @param progress @see BeeVideoProcessiveWithIdBlock
 @param completion @see BeeFileDownloadCompletion
 @return
 */
- (NSString *)downloadVideo:(NSString *)idf
                   business:(NSString *)business
                   progress:(BeeVideoProcessiveWithIdBlock)progress
                 completion:(BeeVideoDownloadCompletion)completion;

/**
 上传视频文件

 @param idf
 @param business
 @param progress @see BeeVideoProcessiveWithIdBlock
 @param completion @see BeeFileUploadCompletion
 @return
 */
- (NSString *)uploadVideo:(NSString *)idf
                 business:(NSString *)business
                 progress:(BeeVideoProcessiveWithIdBlock)progress
               completion:(BeeVideoUploadCompletion)completion;

/**
 取消下载/上传任务

 @param idf 唯一标识
 @param business
 @return
 */
- (BOOL)cancelTaskWithIdentifier:(NSString *)idf business:(NSString *)business;

/**
 取消下载/上传任务

 @param taskId 任务id
 @return
 */
- (BOOL)cancelTaskWithTaskId:(NSString *)taskId;

/**
 根据localId获取真实的 url或本地filepath

@param localId或DJangoId
@return
*/
- (NSString *)getRealPathFromLocalId:(NSString *)localId;
// 增加bizType参数
- (NSString *)getRealPathFromLocalId:(NSString *)localId withBizType:(NSString *)bizType;
// 增加present参数,分辨率
- (NSString *)getRealPathFromLocalId:(NSString *)localId withBizType:(NSString *)bizType andPreset:(NSString *)preset;

/**
 生成封面图的localId

@param image: poster对应的UIImage对象
@return
*/
- (NSString *)getLocalIdWithPosterImage:(UIImage *)image;

/**
*  根据url下载poster
*
*  @param  url
*  @param  complete    完成回调
*
*  @return 用于取消任务的taskId
*/
- (NSString *)getPosterFromUrl:(NSString *)url completion:(BeeVideoDownloadImageCompletion)complete;

/**
 *  获取视频缩略图
 *  如果传的是localId，会直接从缓存中查询，并在当前线程中调用complete
 *
 *  @param  identifier  视频id
 *  @param  progress    下载进度百分比回调
 *  @param  complete    完成回调
 *
 *  @return 用于取消任务的taskId
 */
- (NSString *)getThumbnailWithIdentifier:(NSString *)identifier
                                progress:(BeeVideoProcessiveWithIdBlock)progress
                              completion:(BeeVideoDownloadImageCompletion)complete;

@end

#endif /* IBeeVideoManager_h */
