//
//  BeeVideoPosterPlugin.h
//  BeeMediaPlayer
//
//  Created by manyi.zsf on 2019/4/2.
//  Copyright © 2019年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "IBeeVideoPlayerPlugin.h"

typedef NS_ENUM(NSInteger, BeeVideoPosterType) {
    BeeVideoPosterType_Http,
    BeeVideoPosterType_DjangoId,
    BeeVideoPosterType_Vid
};

@protocol BeeVideoPosterPluginDelegate <NSObject>

- (void)BeeVideoPosterStartPlay;

@end

@interface BeeVideoPosterPlugin : UIImageView<BeeVideoPlayerPluginDelegate>

@property (nonatomic, strong, readonly) UIButton *playBtn;

@property (nonatomic, weak) id<BeeVideoPosterPluginDelegate> delegate;
//是否显示播放按钮，默认YES
@property (nonatomic, assign) BOOL showPlayBtn;

//开个接口给GetVideoPoster的jsapi调用
+ (void)getImageWithVideoUrl:(NSString *)videoUrl type:(BeeVideoPosterType)type extraInfo:(NSDictionary *)extraInfo andCompletion:(void (^)(UIImage *image))completion;

- (void)showWithPosterUrl:(NSString *)posterUrl;
- (void)showWithVideoUrl:(NSString *)videoUrl type:(BeeVideoPosterType)type andExtraInfo:(NSDictionary *)extraInfo;
- (void)reset;

/// 调用强制显示poster
/// @param front 现在在最上层，  默认为false ，现在在当前层级
- (void)showPoster:(bool)front;

@end
