//
//  BeeVideoListPlugin.h
//  BeeMediaPlayer
//
//  Created by zidan on 2019/9/17.
//  Copyright © 2019 Alipay. All rights reserved.
//
#import "IBeeVideoPlayerPlugin.h"

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN


@interface BeeVideoListPlugin : NSObject<BeeVideoPlayerPluginDelegate>

@property (nonatomic, copy)   NSArray<NSString *> *dataSource;

@property (nonatomic, strong, readonly) UIView *bgView;

@property (nonatomic, strong, readonly) UIScrollView *listView;

@property (nonatomic, strong) UIColor *selectedColor; //选中的颜色 默认 #108EE9
@property (nonatomic, strong) UIColor *normalColor; //选项正常颜色 默认 白色
@property (nonatomic, assign) CGFloat optionHeight; // 选项的高度 默认是 50  间隙为5


- (void)reloadData;

- (void)showListView:(BOOL)animation;

- (void)hideListView:(BOOL)animation;


/**
 判断当前的选项是否可以点击
 
 @param index
 @return YES / NO
 */
- (BOOL)shouldHighlightRowAtIndex:(NSInteger)index;

- (BOOL)currentSourceSeleted:(NSString *)currentData index:(NSInteger)currentIndex;

- (void)didSelected:(NSString *)seletedData index:(NSInteger)index;


@end

NS_ASSUME_NONNULL_END
