//
//  BeeVideoFloatViewManager.h
//  BeeMediaPlayer
//
//  Created by manyi.zsf on 2020/3/25.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#ifndef NB_INSIDE
#import <BeeViews/BeeFloatViewManager.h>

typedef NS_ENUM(NSInteger, BeeVideoFloatViewManagerLevel) {
    BeeVideoFloatViewManagerLevel_None      = BeeFloatViewManagerLevel_None,
    BeeVideoFloatViewManagerLevel_Page      = BeeFloatViewManagerLevel_Page,          //跟随当前页面，只在当前页显示浮窗
    BeeVideoFloatViewManagerLevel_Program   = BeeFloatViewManagerLevel_Program,       //同一小程序内部跳转可一直显示浮窗，如淘宝直播
    BeeVideoFloatViewManagerLevel_Global    = BeeFloatViewManagerLevel_Global,        //全局浮窗
};

@protocol BeeVideoFloatViewManagerDelegate <BeeFloatViewManagerDelegate>

@end

@protocol IBeeVideoFloatViewManagerProtocol <IBeeFloatViewManagerProtocol>

@end

#else

typedef NS_ENUM(NSInteger, BeeVideoFloatViewManagerLevel) {
    BeeVideoFloatViewManagerLevel_None,
    BeeVideoFloatViewManagerLevel_Page,          //跟随当前页面，只在当前页显示浮窗
    BeeVideoFloatViewManagerLevel_Program,       //同一小程序内部跳转可一直显示浮窗，如淘宝直播
    BeeVideoFloatViewManagerLevel_Global,        //全局浮窗
};

@protocol BeeVideoFloatViewManagerDelegate <NSObject>

- (BOOL)canShowFloatView;                           //业务决定是否允许浮窗显示，会在willShow之前回调
- (void)floatViewWillShow:(UIView *)view;           //浮窗将要显示
- (void)floatViewDidShow:(UIView *)view;            //浮窗已经显示
- (void)floatViewWillHide:(UIView *)view;           //浮窗将要隐藏
- (void)floatViewDidHide:(UIView *)view;            //浮窗已经隐藏
- (void)floatViewEnded:(UIView *)view;              //浮窗终结通知，需要业务处理view的暂停逻辑
- (void)floatViewCloseBtnClicked:(UIView *)view;    //浮窗关闭按钮点击事件
- (void)floatViewClicked:(UIView *)view;            //浮窗自身被点击事件

@end

@protocol IBeeVideoFloatViewManagerProtocol <NSObject>

//加入浮窗管理
- (void)addFloatView:(UIView *)view ofVC:(UIViewController *)vc withLevel:(BeeVideoFloatViewManagerLevel)level andDelegate:(id<BeeVideoFloatViewManagerDelegate>)delegate;
//移除浮窗管理
- (void)removeFloatView:(UIView *)view;
//显示浮窗
- (void)showFloatView:(UIView *)view;
//隐藏浮窗
- (void)hideFloatView:(UIView *)view;
//浮窗是否显示
- (BOOL)isFloatViewShowing:(UIView *)view;

//设置浮窗对应的schemaUrl
- (void)setFloatView:(UIView *)view withSchemaUrl:(NSString *)schemaUrl;
//设置浮窗显示时用于计算浮窗大小的宽高比，比如播放器需要以视频真实的宽高比为准
- (void)setFloatView:(UIView *)view withRealSize:(CGSize)size;
//显示浮窗缩放按钮
- (void)showZoomBtnInFloatView:(UIView *)view;

@end

#endif



@interface BeeVideoFloatViewManager : NSObject <IBeeVideoFloatViewManagerProtocol>

+ (instancetype)sharedManager;

@end
