//
//  BeeVideoCreateFactory.h
//  BeeMediaPlayer
//
//  Created by manyi.zsf on 2021/6/4.
//  Copyright © 2021 Alipay. All rights reserved.
//

#import "BeeVideoPlayerView.h"

typedef void(^configurationBlock)(BeeVideoPlayerView *player);

@interface BeeVideoCreateFactory : NSObject

+ (instancetype)sharedFactory;

// 预加载播放器，直接返回播放器对象，factory不管理对象实例
// videoUrl: 需要加载的视频源
// business: 业务标识
// configuration: 播放器配置回调，可以设置播放器的初始化参数
// return: YES-成功， NO-超过限制
// ！！！注意：此方法会强制isAutoPlay=NO;isMuted=YES
- (BeeVideoPlayerView *)preparePlayerWithVideoUrl:(NSString *)url
                         business:(NSString *)business
               needDefaultPlugins:(BOOL)needDefaultPlugins
                    configuration:(configurationBlock)block;

// 预加载播放器
// key: 关联播放器对象，业务需保证唯一性
// videoUrl: 需要加载的视频源
// business: 业务标识
// configuration: 播放器配置回调，可以设置播放器的初始化参数
// ！！！注意：此方法会强制isAutoPlay=NO;isMuted=YES
- (void)preparePlayerWithKey:(NSString *)key
                    videoUrl:(NSString *)url
                    business:(NSString *)business
          needDefaultPlugins:(BOOL)needDefaultPlugins
               configuration:(configurationBlock)block;

// 根据key查找并返回已经prepare的播放器对象
// 如果没找到会new一个新的播放器对象返回，只是new一个对象，业务需要自己初始化设置
// 可通过返回对象的videoUrl属性是否为nil判断是prepare的播放器还是new的播放器
- (BeeVideoPlayerView *)getPlayerByKey:(NSString *)key;

// 回收播放器，并关联key
- (void)reusePlayer:(BeeVideoPlayerView *)player forKey:(NSString *)key;

// 根据key查找并清除关联的播放器对象
- (void)clearPlayerByKey:(NSString *)key;

// 清除所有预加载播放器
- (void)clearAllPlayer;

@end
