//
//  BeeVideoConfigManager.h
//  BeeMediaPlayer
//
//  Created by manyi.zsf on 2019/11/18.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BeeVideoPlayerView.h"
#import "IBeeVideoManager.h"
#import "IBeeAudioSessionManager.h"
#import "IYouKuVideoManager.h"
//#ifdef NB_INSIDE
//#import <NBInside/DTNetReachability.h>
//#else
//#import <APMobileNetwork/DTNetReachability.h>
//#endif

#define sharedVideoManager [[BeeVideoConfigManager sharedManager] getVideoManager]
#define sharedAudioSessionManager [[BeeVideoConfigManager sharedManager] getAudioSessionManager]
#define sharedYouKuVideoManager [[BeeVideoConfigManager sharedManager] getYouKuVideoManager]

@interface BeeVideoConfigManager : NSObject

// 网络状态
@property (nonatomic, assign, readonly) MPAASNetworkStatus networkStatus;

+ (instancetype)sharedManager;

// 新建播放器内核
- (id<IBeeVideoPlayer>)newPlayer:(BeePlayerCoreMode)coreMode withFrame:(CGRect)frame;

// @see IBeeVideoManager
- (id<IBeeVideoManager>)getVideoManager;
// @see IBeeAudioSessionManager 管理音频互斥
- (id<IBeeAudioSessionManager>)getAudioSessionManager;
// @see IYouKuVideoManager
- (id<IYouKuVideoManager>)getYouKuVideoManager;

- (void)setUserDefaultsObject:(id)object forKey:(NSString *)key;
- (id)userDefaultsObjectForKey:(NSString *)key;
// 埋点上报
- (void)logEventWithId:(NSString *)eventId andData:(NSDictionary *)data;
- (void)logEventWithId:(NSString *)eventId bizType:(NSString *)bizType andData:(NSDictionary *)data;

@end
