//
//  BeeVideoCenterPlayPlugin.h
//  BeeMediaPlayer
//
//  Created by zidan on 2019/5/15.
//  Copyright © 2019 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>

#import "IBeeVideoPlayerPlugin.h"

NS_ASSUME_NONNULL_BEGIN

@protocol BeeVideoCenterPlayDelegate <NSObject>

- (BOOL)loadingViewCanShow;

@end

@class BeeVideoPlayerView;
@interface BeeVideoCenterPlayPlugin : NSObject<BeeVideoPlayerPluginDelegate>


@property (nonatomic, weak) BeeVideoPlayerView *playerView;

@property (nonatomic, assign) NSTimeInterval lastClickTime;
@property (nonatomic, strong) UIButton *centerPlayBtn;
//中间播放按钮是否显示暂停状态，默认NO
@property (nonatomic, assign) BOOL isShowCenterPlayWithPauseState;

@property (nonatomic, weak) id<BeeVideoHandlerDelegate> delegate;
@property (nonatomic, weak) id<BeeVideoCenterPlayDelegate> centerDelegate;


- (void)updateUIWithState:(BEEVideoPlayerState)state;
- (void)updateCenter;
@end

NS_ASSUME_NONNULL_END
