//
//  BEELocationPicker+process.h
//  BeeLocationPicker
//
//  Created by 莜阳 on 17/2/23.
//  Copyright © 2017年 Alipay. All rights reserved.
//

//#import <O2OCommon/O2OLocationManager.h>
#import <APCommonUI/APTableView.h>
#import "BEELocationSwitchTabView.h"

typedef void(^BeeReGeocodeCompletedBlock)(AMapPOI *poi, NSError *error);

// ----------------------------//

//
typedef NS_ENUM(NSInteger, BEELocationPickerStyle)
{
    BEELocationPickerStyleSimpleEdition = 0,                    // 不带地图         ---  记录生活
    BEELocationPickerStyleWithMap = 1,                         // 仅带地图            --- 发送位置
    BEELocationPickerStyleWithMapAndSwichTab = 2,             // 带地图且带分类tab    --- 到位
    BEELocationPickerStyleSearchLocation = 3                 // 只有搜索功能的模式
};

typedef NS_ENUM(NSInteger, BEELocationPOIItemType)
{
    BEELocationPOIItemTypeDefault = 1,             // 同时展示"不显示位置"+"杭州市(城市名)"
    BEELocationPOIItemTypeNone = 1 << 2,          //  同时隐藏"不显示位置"+"杭州市(城市名)"
    BEELocationPOIItemTypeWithCity = 1 << 3,     //  隐藏"不显示位置"+展示"杭州市(城市名)"
    BEELocationPOIItemTypeWithNonePOI = 1 << 4, //  展示"不显示位置"+隐藏"杭州市(城市名)"
};

// --------------  delegate  --------------//

//
@class BEELocationPicker;
@protocol BEELocationPickerDelegate <NSObject>

@optional
- (void)locationPicker:(BEELocationPicker *)sender poiDidSelected:(AMapPOI *)poi; // 本次选中的POI
- (void)locationPickerDidCancelled:(BEELocationPicker *)sender; // 用户点击返回键退出
- (void)locationPicker:(BEELocationPicker *)sender // 当前选中的地理位置的快照，只有在设置 needMapView = YES 才有效
        poiDidSelected:(AMapPOI *)poi
                 image:(UIImage *)image;
@end

// --------------  VC  --------------//

//
@class BEELocationLoadingView, BEELocationPickerCell, BeeLocationSwitchTabView, BEELocationPickerParams;
#ifdef NB_INSIDE
@interface BEELocationPicker : DTViewController
{
    ////////////////////////////适配无LBS服务的情况/////////////////
    BEELocationSwitchTabType mPaaSSearchType;
    NSUInteger mPaaSPageIndex;
}

#else
@interface BEELocationPicker : BEEBaseController
#endif

@property (nonatomic, weak) id<BEELocationPickerDelegate> delegate;
@property (nonatomic, strong) NSString *titleText;      // 可以定制化 title 文案，默认文案：你在哪里
@property (nonatomic, strong) NSString *rightBarBtnText; // 可定制化 titleBar 右侧按钮文案，默认文案：发送
@property (nonatomic, strong) NSString *appkey __deprecated;         // 标记业务来源，可选
@property (nonatomic, assign) double mapRange;          // 指定地图范围，可选
@property (nonatomic, strong) NSString *outOfRangeTip;  // 超出 mapRange 的提示信息，可选
@property (nonatomic, assign) BOOL hideRegeoLocation;   // 隐藏逆地理 POI 项，默认显示

////////////////////////////适配无LBS服务的情况/////////////////
@property(nonatomic,strong) AMapSearchAPI *mapSearch;//高德搜索服务
@property(nonatomic,strong) BeeReGeocodeCompletedBlock mPaaSreGeocodeCompletedBlock;//逆地理完成后的回调

// 初始化参数block
- (instancetype)initWithparamsBlock:(void (^)(BEELocationPickerParams *params))params_block;

// 根据经纬度获取当前位置信息
//+ (void)reGeocodeWithLocation:(CLLocationCoordinate2D)location completion:(BeeReGeocodeCompletedBlock)completion;

@end

// --------------  数据 model  --------------//

// 经纬度对象
@interface BEECLLocationObject : NSObject

@property (nonatomic, assign) CLLocationCoordinate2D coordinate;
@property (nonatomic, assign) CLLocationAccuracy horizontalAccuracy;
@property (nonatomic, assign) BOOL coordinateHasConverted;              // 当前经纬度是否已经是 GCJ-02 坐标体系

@end

// 参数传入block
@interface BEELocationPickerParams : NSObject

@property (nonatomic, assign) BEELocationPickerStyle locationStyle;
@property (nonatomic, strong) BEECLLocationObject *locationOBJ;
@property (nonatomic, strong) AMapPOI *locatedPOI; // 当前定位的 POI
@property (nonatomic, strong) AMapPOI *lastSelectedPOI; // 上次选中的 POI
@property (nonatomic, strong) NSString *cityName;       // 城市名称
@property (nonatomic, strong) NSString *keywords;       // 搜索关键词
@property (nonatomic, assign) BOOL isChinese;           // 指定当前搜索是国内还是国外数据，不带经纬度的搜索需要设置此参数
@property (nonatomic, assign) BEELocationPOIItemType showPOIItem;
@property (nonatomic, strong) NSString *business;       // 标记业务来源，可选
@property (nonatomic, assign) BOOL needReversingGeo;    // 是否要逆地理
@property (nonatomic, strong) NSString *placeHolder;    // 搜索框内的文案定制化
@property (nonatomic, assign) CLLocationCoordinate2D customInitCoordinate;  // 地图直接跳转到指定经纬度
@property (nonatomic, assign) CGSize snapShotSize;      // 地图截图尺寸
@property (nonatomic, assign) BOOL showTelephoneIcon;   // 点击进行当前POI项的电话，如果当前POI点获取不到电话则不显示电话icon（默认不展示）
@property (nonatomic, assign) BOOL showMapIcon;         // 展示地图icon，支持跳转苹果地图 & 高德地图进行导航（默认不展示）
@property (nonatomic, assign) BOOL showDistanceInfo;    // 展示距离信息（默认不展示）
@property (nonatomic, strong) NSString *poiSearchType;  // 指定搜索类型，不指定则走组件默认类型，支持类型按"|"拼接传多个，实际类型详细类型见 http://lbs.amap.com/api/webservice/guide/api/search#introduce 中下载POI分类编码和城市编码表文档
@property (nonatomic, assign) BOOL isShowConfirmSelectBtn;  // 控制右上角发送按钮的显示与隐藏，主要给JSAPI使用
@property (nonatomic, strong) NSString *source_appid;       // 来源id
@property (nonatomic, strong) NSString *referer_url;        // 来源url
@property (nonatomic, assign) CGFloat scale;                // 地图zoomLevel
@property (nonatomic, copy) NSString *markerTitle;            // fullMap 模式下markTitle
@property (nonatomic, assign) BOOL fullMap;                 // 地图全屏选点模式
@property (nonatomic, assign) BOOL hideSearch;              // 隐藏搜索入口
@end

