//
//  BeeCityPickerViewController.h
//  BeeCityPicker
//
//  Created by niki on 2018/3/28.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "BeeCityDataModel.h"

@protocol BeeCityPickerVCDelegate;

typedef void(^BeeCitySelectBlock) (BeeCityVOModel *city);

/*
*******************************************************************
****数据模型解析文档：https://lark.alipay.com/tyhq8h/ould4l/buyw2u****
*******************************************************************
*/

@interface BeeCityPickerViewController : DTViewController

@property (nonatomic, weak) id<BeeCityPickerVCDelegate> citySelDelegate; // 城市选择回调
@property (nonatomic, strong) NSArray<BeeCityDataModel *> *citiesModels;
@property (nonatomic, strong) NSDictionary *config;
@property (nonatomic, strong) NSDictionary *uiConfig;
// 支持对内置数据差量更新
@property (nonatomic, strong) NSArray<BEECity *> *addCityArray;
@property (nonatomic, strong) NSArray<NSString *> *removeCityArray;
@property (nonatomic, strong) NSArray<NSString *> *hotCityArray;
// 新增adVersion逻辑
@property (nonatomic , strong) NSString *adVersion;
/**
 @param cityDatas 展示的数据列表
 @return return BeeCityPickerViewController 页面实例
 */
- (instancetype)initWithCityDatas:(NSArray<BeeCityDataModel *> *)cityDatas
                         backToVC:(UIViewController *)backtoVC
                       completion:(BeeCitySelectBlock)completion;

- (instancetype)initWithCityDatas:(NSArray<BeeCityDataModel *> *)cityDatas
                         backToVC:(UIViewController *)backtoVC
                       completion:(BeeCitySelectBlock)completion
                        adVersion:(NSString *)adVersion;

- (instancetype)initWithBacktoVC:(UIViewController *)backtoVC
                      completion:(BeeCitySelectBlock)completion;

// 刷新数据
- (void)reloadWithDataList:(NSArray<BeeCityDataModel *> *)datas;

+ (BeeCityVOModel *)dataModelConvert:(BEECity *)item;

@end


@protocol BeeCityPickerVCDelegate <NSObject>
@optional
/**
 * @desc 完成城市选择之后，返回给业务方处理，根据参数判断是否需要将城市选择的VC pop出去
 * @param needPop (BOOL *) 业务方告诉组件是否需要将组件的VC pop出去，Default=YES.
 */
- (void)cityPickerController:(BeeCityPickerViewController *)cityController
               didSelectCity:(BeeCityVOModel *)cityVO
           needPopCityPicker:(BOOL)needPop;

- (void)locatedCityLocation:(CLLocation *)location
                  cityModel:(BeeCityVOModel *)cityVO
              locatedCityId:(NSString *)locatedCityId;

// 点击搜索栏
- (void)cityPickerController:(BeeCityPickerViewController *)cityController didClickSearchBar:(BOOL)clicked;
// 点击索引
- (void)cityPickerController:(BeeCityPickerViewController *)cityController didClickBladeView:(BOOL)clicked;

- (void)cityPickerController:(BeeCityPickerViewController *)cityController viewDidAppear:(BOOL)animated;

- (void)cityPickerController:(BeeCityPickerViewController *)cityController viewWillDisappear:(BOOL)animated;

- (void)cityPickerController:(BeeCityPickerViewController *)cityController didCancelSelect:(BOOL)cancel;

@end
