//
//  BeeCityDataModel.h
//  BeeCityPicker
//
//  Created by niki on 2018/3/28.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BEECity.h"

@class BeeCityDataModel;


/* AreaLevel：地区级别静态类
 AREALEVEL_CONTINENT = 1;大洲
 AREALEVEL_COUNTRY = 2;国家
 AREALEVEL_PROVINCE = 3;省份
 AREALEVEL_CITY = 4;城市
 AREALEVEL_DISTRICT = 5;地区
 AREALEVEL_TOWN = 6;乡镇
 AREALEVEL_STREET = 7;街道
 AREALEVEL_STREET_WITH_POIS = 8;兴趣点
 AREALEVEL_BASIC_GEOFENCE = 12;区域
 AREALEVEL_DEFAULT = 0;缺省值
 */


/* 关于模块类型说明
 静态块0，定位块1，国家块2，链接块3
 静态块 比如说热门区域
 定位块 就是指具备定位展示的区域
 国家块 就是列表式的区块
 链接块 蓝色的跳转功能的区块
 */

@interface BeeCityVOModel : BEECity //NSObject

@property (nonatomic, strong) NSString *cityName __deprecated_msg("外部请不要使用该属性"); //
@property (nonatomic, copy) NSString *enName; // 英文名
@property (nonatomic, assign) NSInteger areaLevel; // 地区级别，默认areaLevel=4，城市
@property (nonatomic, strong) NSMutableArray <BeeCityDataModel *>*cityDataList; // 非必须，国家级别所需子页面数据
@property (nonatomic, assign) BOOL enableLongPressDelete; // 是否支持长按删除，56首页城市选择
- (NSArray *)pinyinArray;
@end

typedef NS_ENUM(NSInteger, BeeCityTabType) {
    BeeCityTabTypeStatic = 0, // 静态模块
    BeeCityTabTypeLocation = 1, // 定位模块
    BeeCityTabTypeCountry = 2, // 国家块
    BeeCityTabTypeLink = 3, // 链接块
    BeeCityTabTypeSingleItem = 4, // 特殊模块(国家)
    BeeCityTabTypeLocationAndHistory = 5 // 新增定位+历史模式
};

// 以下type类型用于指定当前数据列表需要填充
typedef NS_ENUM(NSInteger, BeeCityTabFillType) {
    BeeCityTabFillTypeNone = 0,         // 不用任何内置填充数据，使用业务方传进来的数据
    BeeCityTabFillTypeAllCities = 1,    // 使用组件内置国家城市数据(包含境内境外数据)
    BeeCityTabFillTypeMainLand = 2,    // 使用组件内置境内城市数据填充
    BeeCityTabFillTypeOversea = 3,      // 使用组件内置境外城市数据填充
    BeeCityTabFillTypePopular = 4,      // 使用组件内置热门城市数据填充
};

@interface BeeCityTabModel : NSObject

@property (nonatomic, assign) BeeCityTabFillType filtType; // 填充数据类型
@property (nonatomic, strong) NSString *name; // 分组名称
@property (nonatomic, strong) NSString *indexName; // 右侧导航索引名称
@property (nonatomic, assign) BeeCityTabType type; // 分组样式类型，静态块0，定位块1，国家块2，链接块3,singleItem 4(国家)
@property (nonatomic, assign) BOOL needSearch; // 是否可以搜索，默认值YES
@property (nonatomic, assign) NSInteger areaShowMode; // 0：不做限制 1：定位境内展示 2：定位境外展示 default为0
@property (nonatomic, strong) NSMutableArray<BeeCityVOModel *> *cityVOList; // 城市数据实体抽象列表

@end

typedef NS_ENUM(NSInteger, BeeCityPageType) {
    BeeCityPageTypeContinents = 0,  // 大洲
    BeeCityPageTypePopular = 1,     // 热门
    BeeCityPageTypeRecommend = 2    // 推荐
};

// 顶部tab模型抽象
@interface BeeCityPageModel : NSObject

@property (nonatomic, assign) BeeCityPageType type; // 标记当前pageModel类型：0表示大洲，1表示热门区域，2表示推荐，默认值是 0
@property (nonatomic, assign) BOOL selected; // 标记当前左侧选项卡是否为选中
@property (nonatomic, assign) BOOL hasAlphaIndex; // 是否展示右侧快捷字母索引导航
@property (nonatomic, strong) NSString *name; // 左侧分段segment名称
@property (nonatomic, strong) NSMutableArray<BeeCityTabModel *> *cityTabList; // 右侧内容区块每一个分组的抽象

@end

@interface BeeCityDataModel : NSObject

@property (nonatomic, assign) BOOL needLocalData; // 设置是否需要本地默认内置数据填充，默认不需要
@property (nonatomic, assign) BOOL hasSearchBar; // 标记是否有搜索条
@property (nonatomic, strong) NSString *placeHolder; // 搜索条的底纹词，默认是搜索
@property (nonatomic, assign) BOOL selected; // 标记当前tab是否为选中tab，默认选中第一项
@property (nonatomic, strong) NSString *name; // 顶部tab名称
@property (nonatomic, strong) NSMutableArray<BeeCityPageModel *> *cityPageList; // 顶部tab模型抽象
@property (nonatomic, assign) BOOL hideLocation; // 是否需要隐藏定位模块

@end


//////////// 纵向选项卡

@interface BeeVerticalTabModel : NSObject <AUVerticalTabViewDataProtocol>

@property (nonatomic, strong) NSString *name;

@end


