//
//  BEECityDataSource.h
//  BeeCityPicker
//
//  Created by 百喻 on 2020/6/11.
//  Copyright © 2020 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>

@class BeeCityVOModel;
//NS_ASSUME_NONNULL_BEGIN
typedef void(^CityDataLoadedResult)(NSArray *list,NSString *md5Value,NSData *oriData,SInt32 status);
typedef void(^CityDataLoadedBlock)(NSArray *list,NSString *md5Value,NSData *oriData);
typedef void(^CityInfoCallback) (BeeCityVOModel *city);
typedef void(^CityInfosCallback) (NSDictionary * cities);   // @{code:BeeCityVOModel}

typedef NS_ENUM(NSInteger, BeeCityDataType) {
    BeeCityDataTypeDefault      = 0,
    BeeCityDataTypeOversea      = 5,  // 海外
    BeeCityDataTypeAllCity      = 6,  // 中国的所有城市(包括港澳台)
    BeeCityDataTypeRegion       = 7,  // 中国的省市区(包括港澳台, 带层级关系)
    BeeCityDataTypeAllCountry   = 8,  // 全球国家、省份、城市(港澳台在中国内部，带层级关系)、区县拉取
    BeeCityDataTypeMarketing  = 100,  // 特殊区县数据
};

@interface BEECityDataSource : NSObject
+ (instancetype)shareInstance;
//---  config  ---//
@property (nonatomic,assign) BOOL enableDistrict;
@property (nonatomic,strong) NSArray *cityBlackList;
@property (nonatomic,assign) BOOL enableENMode;
@property (nonatomic,assign) BOOL enableMainlandENMode;
@property (nonatomic,assign) BOOL enableCacheInfoRefresh;
@property (nonatomic,strong) NSDictionary *langCfgDic;
@property (nonatomic,strong) NSDictionary *cityLangCfgDic;

//---  update   ---//
- (void)checkAndUpdateCityData;
- (void)checkAndUpdateCityDataWithType:(BeeCityDataType)type appId:(NSString *)appId;
- (void)checkAndUpdateMarketingData;
- (void)checkAndUpdateUserHistroyCities;


//---  loadDataFromRPC   ---//
// 拉取城市数据
+ (void)loadDistrictDataWithType:(BeeCityDataType)type appKey:(NSString *)appKey adVersion:(NSString *)adVersion completionResult:(CityDataLoadedResult)completionResult; // 包含rpc status
+ (void)loadDistrictDataWithType:(BeeCityDataType)type appKey:(NSString *)appKey completion:(CityDataLoadedBlock)completion;
+ (void)loadDistrictDataWithType:(BeeCityDataType)type appKey:(NSString *)appKey adVersion:(NSString *)adVersion completion:(CityDataLoadedBlock)completion;


//---  check   ---//
- (BOOL)isMarketingDistrictWithDistrictCode:(NSString *)code;
- (NSArray *)getMarketingCityVOList;
- (void)getCityInfoWithCode:(NSString *)code callback:(CityInfoCallback)callback;
- (void)getCityInfosWithCodes:(NSArray *)codes callback:(CityInfosCallback)callback;
- (BeeCityVOModel *)getCityVOWithDistrictCode:(NSString *)code;
- (BeeCityVOModel *)getDistrictVOWithDistrictCode:(NSString *)code;
// 香港 -> 中国香港; 澳门 -> 中国澳门
- (NSString *)updateDescribeName:(NSString *)describeName code:(NSString *)code;
- (void)updateCityENName:(BeeCityVOModel *)cityModel;
- (NSString *)getCityENNameWithCode:(NSString *)code defaultName:(NSString *)defaultName;
- (NSString *)getENNameWithName:(NSString *)name defaultName:(NSString *)defaultName;
@end

//NS_ASSUME_NONNULL_END
