//
//  BCMaskView.h
//  BeeCapture
//
//  Created by manyi.zsf on 2017/9/22.
//  Copyright © 2017年 Alipay. All rights reserved.
//

#ifndef BCMaskView_h
#define BCMaskView_h

typedef NS_ENUM(NSInteger, CenterTipPosition) {
    CenterTipPosition_above = 1,
    CenterTipPosition_center = 0,
    CenterTipPosition_below = -1,
};

//给业务方的回调
@protocol BCMaskViewDelegate <NSObject>

@optional
- (void)sampleImageClicked;
- (void)previewImageClicked;
- (void)recordBtnClicked:(BOOL)isEnable;

@end

//组件内部的回调
@protocol BCMaskViewPrivateDelegate <NSObject>

@optional
- (void)flashBtnClicked:(BOOL)isSelected;

@end

@protocol BCMaskView <NSObject>

- (void)addCaptureRect:(BOOL)needCaptureFrame;
- (CGRect)transparentRect:(BOOL)isCaptureRect;
- (void)setMaskDelegate:(id<BCMaskViewDelegate>)delgate;
- (void)setMaskPrivateDelegate:(id<BCMaskViewPrivateDelegate>)delegate;

@optional
- (void)viewWillAppear;
- (void)viewWillEnterForeground;
- (void)resetRectWithPercentOfWidth:(double)widthPercent andHeight:(double)heightPercent orAspectRatio:(double)aspectRatio;

//RectMaskView

//SidesMaskView
- (void)setFocusImageUrl:(NSString *)imageUrl;
- (void)setGuideImageUrl:(NSString *)imageUrl;
- (void)setSampleImageUrl:(NSString *)imageUrl;
- (void)setPreviewImageUrl:(NSString *)imageUrl;
- (void)setSceneTextString:(NSString *)text;
- (void)setSceneTextColor:(UIColor *)color;
- (void)setTransparentBackground;
- (void)showBottomBar:(BOOL)isShow;
- (void)showFlashBtn:(BOOL)isShow;
- (void)switchFlashMode:(BOOL)isOn;
- (void)showScanAnimation:(BOOL)isShow;

@end

#endif /* BCMaskView_h */
