//
//  TASUtils.h
//  TinyappService
//
//  Created by 闻蹊 on 2018/8/1.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AriverNebulaAppManager/NAMApp.h>

NS_INLINE CGFloat TAValueAfterScale(CGFloat value)
{
    if (AUIsPad() || AUDeviceIsLowerIphone6()) {
        return value;
    }

    BOOL isLandscape = UIDeviceOrientationIsLandscape([[UIDevice currentDevice] orientation]);
    CGFloat minFactor = MIN([UIScreen mainScreen].bounds.size.width / (isLandscape?667:375), [UIScreen mainScreen].bounds.size.height / (isLandscape?375:667));
    return value * minFactor;
}

/// 强制String类型
/// @param str 传入的对象
NSString *TSMandatoryString(NSString *str);

/// 强制保证dictionary的string类型
/// @param key keypath
/// @param dic operating dictionary
NSDictionary *TSDicMandatoryStrInKeypath(NSString *key,NSDictionary *dic);

@protocol TACustomGlobalMenuItem <NSObject>
/**
 点击菜单顶部主体的delegate。
 
 @param app 小程序app。
 */
- (void)didClickMenuHeader:(NAMApp*)app;

/**
 点击自定义菜单Item的delegate。
 
 @param foundItem 点击的Item相关信息。
 item内容如下：
 @{
 @"app":nbApp,                 // 当前item所在的小程序app
 @"name":foundItem[@"name"],   // 当前item显示的名称
 @"index":index                // 当前item所在的位置
 }
 */
- (void)didClickCustomGlobalMenuItem:(NSDictionary *)foundItem;

/**
 可以修改一部分内嵌的item信息
 
 @param action item信息。
 */
- (void)customEmbeddedItem:(NSDictionary *)item;

@optional

/**
 是否展示箭头
 
 @param app 小程序app。
 
 @return 是否展示
 */
- (BOOL)shouldShowArrowImage:(NAMApp*)app;

@end

@interface TASUtils : NSObject

@property(nonatomic, strong) UIColor *customItemColor;      // 自定义右侧关闭按钮颜色。若显示菜单设置按钮，则同时修改设置按钮颜色
@property(nonatomic, strong) UIImage *customCloseImage;     // 自定义右侧关闭按钮图片，建议大小为22*22
@property(nonatomic, assign) BOOL shoulShowSettingMenu;     // 是否显示右上角选项菜单设置按钮
@property(nonatomic, strong) UIImage *customSettingImage;   // 自定义右侧分享按钮图片，建议大小为22*2

// 自定义菜单面板显示Item
// 示例如下
//   [TASUtils sharedInstance].customMenuItems = @[
//   @{@"name":@"收藏", @"menuIconUrl":@"http://pic.alipayobjects.com/e/201212/1ntOVeWwtg.png"},
//   @{@"name":@"首页", @"menuIconUrl":@"http://pic.alipayobjects.com/e/201212/1ntOVeWwtg.png"},
//   @{@"name":@"关于", @"menuIconUrl":@"http://pic.alipayobjects.com/e/201212/1ntOVeWwtg.png"}];
@property(nonatomic, strong) NSArray *customMenuItems;
// 点击自定义菜单Item的delegate。
@property(nonatomic, weak) id <TACustomGlobalMenuItem> delegate;

+(instancetype)sharedInstance;

+ (BOOL)usePresetPopMenu:(NSDictionary *)extendInfo;

+ (BOOL)isInnerTinyApp:(NSString *)appId;

+ (BOOL)isH5ConvertToTinyAppStyle:(NSString *)appId;

+ (BOOL)isOnlyOptionMenuWithLaunchParams:(NSDictionary *)launchParams
                             application:(DTMicroApplication *)app;

+ (BOOL)isValidColorWithHexString:(NSString *)hexString;

/**
 退出当前小程序， 并处理小服务/双十一活动联动关闭问题
 
 @param appId 当前小程序appId
 */
+ (void)exitTinyApplication:(NSString *)appId;

+ (NSString *)getARGBStringFromColor:(UIColor *)color;


/**
 * 确保IconFont已经注册过
 */
+ (void)ensureIconFontRegsitered;

+ (NSString *)transformToValidJSON:(NSString *)originString;
+ (NSString *)transformBackToJSObject:(NSString *)originString;

// 小程序appid应用中心appid,使用应用中心开关AC_RECENT_RELATIONS
+ (NSString *)transfromTinyappId:(NSString *)srcAppId;
@end
