//
//  TAMiniServerManager.h
//  TinyappService
//
//  Created by 应俊康 on 2018/4/16.
//  Copyright © 2018年 Alipay. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <APMobileFramework/APMobileFramework.h>

@interface TAMiniServerManager : NSObject

+(instancetype)shareInstance;

-(BOOL)bindApp:(NSString*)appId miniServer:(DTMicroApplication*)miniServer;

-(BOOL)unBindApp:(NSString*)appId miniServer:(DTMicroApplication*)miniServer;

-(BOOL)startMiniServer:(NSString*)serviceId
              parentId:(NSString*)parentId
              sourceId:(NSString *)sourceId
             extraData:(NSDictionary*)extraData;

-(void)exitAll:(NSString*)appId;

-(NSString *)parentIdWithMiniServer:(DTMicroApplication*)miniServer;

-(NSString *)parentIdWithParams:(NSDictionary *)params;

- (BOOL)openMiniServerIsReachUpperLimit:(NSString *)parentId;

-(BOOL)isMiniServerWithApp:(DTMicroApplication *)app;

-(BOOL)isMiniServerWithParams:(NSDictionary *)params;

-(void)postMsg2App:(NSString*)appId parmas:(NSDictionary*)params;
@end

TAMiniServerManager * TAMiniServerManagerGet();

//

typedef void (^TAHasPermissionBlock)();
@interface TAMiniServerUtil : NSObject
//
+ (void)callPostMsg2App:(NSString *)pluginId parentId:(NSString *)parentId;
//
+ (void)startRPCTask:(NSDictionary *)requestData
   hasPermitionBlock:(TAHasPermissionBlock)block;

@end

